/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.platform.commons.support.ModifierSupport;
import org.spockframework.mock.IInvocationConstraint;
import org.spockframework.mock.IMockInteraction;
import org.spockframework.mock.IMockObject;
import org.spockframework.mock.MockImplementation;
import org.spockframework.mock.constraint.EqualMethodNameConstraint;
import org.spockframework.mock.constraint.EqualPropertyNameConstraint;
import org.spockframework.mock.runtime.ByteBuddyMockMaker;
import org.spockframework.mock.runtime.IMockInteractionValidator;
import org.spockframework.mock.runtime.MockInteraction;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.InvalidSpecException;

final class ByteBuddyMockInteractionValidator
implements IMockInteractionValidator {
    private volatile Class<?> mockClass;
    private volatile Set<String> finalMethods;

    ByteBuddyMockInteractionValidator() {
    }

    @Override
    public void validateMockInteraction(IMockObject mockObject, IMockInteraction mockInteractionParam) {
        Objects.requireNonNull(mockObject);
        Objects.requireNonNull(mockInteractionParam);
        Object instance = Objects.requireNonNull(mockObject.getInstance());
        if (mockObject.getConfiguration().getImplementation() == MockImplementation.GROOVY) {
            return;
        }
        this.initializeClassData(instance);
        this.validate(mockObject, (MockInteraction)mockInteractionParam);
    }

    private void validate(IMockObject mockObject, MockInteraction mockInteraction) {
        for (IInvocationConstraint constraint : mockInteraction.getConstraints()) {
            if (constraint instanceof EqualMethodNameConstraint) {
                EqualMethodNameConstraint methodConstraint = (EqualMethodNameConstraint)constraint;
                String methodName = methodConstraint.getMethodName();
                this.validateNonFinalMethod(mockObject, methodName);
            }
            if (!(constraint instanceof EqualPropertyNameConstraint)) continue;
            EqualPropertyNameConstraint propNameConstraint = (EqualPropertyNameConstraint)constraint;
            this.validateProperty(mockObject, propNameConstraint);
        }
    }

    private void validateProperty(IMockObject mockObject, EqualPropertyNameConstraint propNameConstraint) {
        String propName = propNameConstraint.getPropertyName();
        this.validateNonFinalMethod(mockObject, GroovyRuntimeUtil.propertyToGetterMethodName(propName));
        this.validateNonFinalMethod(mockObject, GroovyRuntimeUtil.propertyToBooleanGetterMethodName(propName));
    }

    private void validateNonFinalMethod(IMockObject mockObject, String methodName) {
        if (this.finalMethods.contains(methodName)) {
            throw new InvalidSpecException("The final method '" + methodName + "' of '" + mockObject.getMockName() + "' can't be mocked by the '" + ByteBuddyMockMaker.ID + "' mock maker. Please use another mock maker supporting final methods.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeClassData(Object mock) {
        Class<?> mockClassOfMockObj = mock.getClass();
        if (this.mockClass == null) {
            ByteBuddyMockInteractionValidator byteBuddyMockInteractionValidator = this;
            synchronized (byteBuddyMockInteractionValidator) {
                if (this.mockClass == null) {
                    this.finalMethods = Arrays.stream(mockClassOfMockObj.getMethods()).filter(m -> !ModifierSupport.isStatic((Member)m)).collect(Collectors.groupingBy(Method::getName)).entrySet().stream().filter(e -> ((List)e.getValue()).stream().allMatch(ModifierSupport::isFinal)).map(Map.Entry::getKey).collect(Collectors.toSet());
                    this.mockClass = mockClassOfMockObj;
                }
            }
        }
        if (this.mockClass != mockClassOfMockObj) {
            throw new IllegalStateException();
        }
    }
}

