/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.spockframework.mock.CannotCreateMockException;
import org.spockframework.mock.runtime.ByteBuddyMockFactory;
import org.spockframework.mock.runtime.IMockMaker;
import org.spockframework.mock.runtime.JavaProxyMockMaker;
import org.spockframework.util.ReflectionUtil;
import spock.mock.MockMakerId;

public class ByteBuddyMockMaker
implements IMockMaker {
    public static final MockMakerId ID = new MockMakerId("byte-buddy");
    public static final String IGNORE_PROP = "org.spockframework.mock.ignoreByteBuddy";
    private static final boolean ignoreByteBuddy = Boolean.getBoolean("org.spockframework.mock.ignoreByteBuddy");
    private static final boolean byteBuddyAvailable = ReflectionUtil.isClassAvailable("net.bytebuddy.ByteBuddy");
    private static final ByteBuddyMockFactory mockFactory = !ignoreByteBuddy && byteBuddyAvailable ? new ByteBuddyMockFactory() : null;
    private static final Set<IMockMaker.MockMakerCapability> CAPABILITIES = Collections.unmodifiableSet(EnumSet.of(IMockMaker.MockMakerCapability.INTERFACE, IMockMaker.MockMakerCapability.CLASS, IMockMaker.MockMakerCapability.ADDITIONAL_INTERFACES, IMockMaker.MockMakerCapability.EXPLICIT_CONSTRUCTOR_ARGUMENTS));

    @Override
    public MockMakerId getId() {
        return ID;
    }

    @Override
    public Set<IMockMaker.MockMakerCapability> getCapabilities() {
        return CAPABILITIES;
    }

    @Override
    public int getPriority() {
        return 200;
    }

    @Override
    public Object makeMock(IMockMaker.IMockCreationSettings settings) throws CannotCreateMockException {
        return Objects.requireNonNull(mockFactory).createMock(settings);
    }

    @Override
    public IMockMaker.IMockabilityResult getMockability(IMockMaker.IMockCreationSettings settings) {
        if (ignoreByteBuddy) {
            return () -> "Byte-buddy was ignored with org.spockframework.mock.ignoreByteBuddy.";
        }
        if (!byteBuddyAvailable) {
            return () -> "The byte-buddy library is missing on the class path.";
        }
        return JavaProxyMockMaker.checkMockClassesAreVisibleInClassloader(settings);
    }
}

