/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.spockframework.mock.IMockConfiguration;
import org.spockframework.mock.IMockController;
import org.spockframework.mock.IResponseGenerator;
import org.spockframework.mock.ISpockMockObject;
import org.spockframework.mock.runtime.BaseMockInterceptor;
import org.spockframework.mock.runtime.MockInvocation;
import org.spockframework.mock.runtime.MockObject;
import org.spockframework.mock.runtime.StaticMockMethod;
import org.spockframework.runtime.GroovyRuntimeUtil;
import spock.lang.Specification;

public class GroovyMockInterceptor
extends BaseMockInterceptor {
    private final IMockConfiguration mockConfiguration;
    private final Specification specification;

    public GroovyMockInterceptor(IMockConfiguration mockConfiguration, Specification specification, MetaClass mockMetaClass) {
        super(mockMetaClass);
        this.mockConfiguration = mockConfiguration;
        this.specification = specification;
    }

    @Override
    public Object intercept(Object target, Method method, Object[] arguments, IResponseGenerator realMethodInvoker) {
        String methodName;
        MockObject mockObject = new MockObject(this.mockConfiguration, target, this.specification, this);
        if (method.getDeclaringClass() == ISpockMockObject.class) {
            return GroovyMockInterceptor.handleSpockMockInterface(method, mockObject);
        }
        Object[] args = GroovyRuntimeUtil.asUnwrappedArgumentArray(arguments);
        if (this.isMethod(method, "getMetaClass", new Class[0])) {
            return this.getMockMetaClass();
        }
        if (this.isMethod(method, "invokeMethod", String.class, Object.class)) {
            return GroovyRuntimeUtil.invokeMethod(target, (String)args[0], GroovyRuntimeUtil.asArgumentArray(args[1]));
        }
        if (this.isMethod(method, "getProperty", String.class) && (methodName = this.handleGetProperty((GroovyObject)target, args)) != null) {
            return GroovyRuntimeUtil.invokeMethod(target, methodName, new Object[0]);
        }
        if (this.isMethod(method, "setProperty", String.class, Object.class)) {
            methodName = GroovyRuntimeUtil.propertyToSetterMethodName((String)args[0]);
            return GroovyRuntimeUtil.invokeMethod(target, methodName, args[1]);
        }
        if (this.isMethod(method, "methodMissing", String.class, Object.class)) {
            throw new MissingMethodException((String)args[0], this.mockConfiguration.getType(), new Object[]{args[1]}, false);
        }
        if (this.isMethod(method, "propertyMissing", String.class)) {
            throw new MissingPropertyException((String)args[0], this.mockConfiguration.getType());
        }
        StaticMockMethod mockMethod = new StaticMockMethod(method, this.mockConfiguration.getExactType());
        MockInvocation invocation = new MockInvocation(mockObject, mockMethod, Arrays.asList(args), realMethodInvoker);
        IMockController controller = this.specification.getSpecificationContext().getMockController();
        return controller.handle(invocation);
    }

    @Override
    public void attach(Specification specification) {
    }

    @Override
    public void detach() {
    }
}

