/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.function.Supplier;
import org.spockframework.mock.IInteractionScope;
import org.spockframework.mock.IMockInteraction;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.TooFewInvocationsError;
import org.spockframework.mock.WrongInvocationOrderError;
import org.spockframework.mock.runtime.MockInteractionDecorator;
import org.spockframework.util.ExceptionUtil;

public class InteractionScope
implements IInteractionScope {
    private static final int MAX_PREVIOUS_INVOCATIONS = 5;
    private final List<IMockInteraction> interactions = new ArrayList<IMockInteraction>();
    private final List<IMockInvocation> unmatchedInvocations = new ArrayList<IMockInvocation>();
    private int currentRegistrationZone = 0;
    private int currentExecutionZone = 0;
    private final Deque<IMockInvocation> previousInvocationsInReverseOrder = new ArrayDeque<IMockInvocation>(5);

    @Override
    public void addInteraction(final IMockInteraction interaction) {
        this.interactions.add(new MockInteractionDecorator(interaction){
            final int myRegistrationZone;
            {
                super(decorated);
                this.myRegistrationZone = InteractionScope.this.currentRegistrationZone;
            }

            @Override
            public Supplier<Object> accept(IMockInvocation invocation) {
                WrongInvocationOrderError wrongInvocationOrderError = InteractionScope.this.currentExecutionZone > this.myRegistrationZone ? new WrongInvocationOrderError(this.decorated, invocation, InteractionScope.this.previousInvocationsInReverseOrder) : null;
                InteractionScope.this.currentExecutionZone = this.myRegistrationZone;
                if (InteractionScope.this.previousInvocationsInReverseOrder.size() == 5) {
                    InteractionScope.this.previousInvocationsInReverseOrder.removeLast();
                }
                InteractionScope.this.previousInvocationsInReverseOrder.addFirst(invocation);
                Supplier<Object> supplierFromDecorated = super.accept(invocation);
                return () -> {
                    Object result = null;
                    Object invocationException = null;
                    try {
                        result = supplierFromDecorated.get();
                    }
                    catch (AssertionError | Exception e) {
                        invocationException = e;
                    }
                    ExceptionUtil.throwWithSuppressed((Throwable)invocationException, (Throwable)((Object)wrongInvocationOrderError));
                    return result;
                };
            }

            @Override
            public String describeMismatch(IMockInvocation invocation) {
                return interaction.describeMismatch(invocation);
            }
        });
    }

    @Override
    public void addOrderingBarrier() {
        ++this.currentRegistrationZone;
    }

    @Override
    public void addUnmatchedInvocation(IMockInvocation invocation) {
        if (invocation.getMockObject().isVerified()) {
            this.unmatchedInvocations.add(invocation);
        }
    }

    @Override
    public IMockInteraction match(IMockInvocation invocation) {
        IMockInteraction firstMatch = null;
        for (IMockInteraction interaction : this.interactions) {
            if (!interaction.matches(invocation)) continue;
            if (!interaction.isExhausted()) {
                return interaction;
            }
            if (firstMatch != null) continue;
            firstMatch = interaction;
        }
        return firstMatch;
    }

    @Override
    public void verifyInteractions() {
        ArrayList<IMockInteraction> unsatisfiedInteractions = new ArrayList<IMockInteraction>();
        for (IMockInteraction interaction : this.interactions) {
            if (interaction.isSatisfied()) continue;
            unsatisfiedInteractions.add(interaction);
        }
        if (!unsatisfiedInteractions.isEmpty()) {
            throw new TooFewInvocationsError(unsatisfiedInteractions, this.unmatchedInvocations);
        }
    }
}

