/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.util.List;
import org.spockframework.lang.ISpecificationContext;
import org.spockframework.mock.CannotCreateMockException;
import org.spockframework.mock.IMockConfiguration;
import org.spockframework.mock.IMockFactory;
import org.spockframework.mock.MockImplementation;
import org.spockframework.mock.MockNature;
import org.spockframework.mock.runtime.IMockMaker;
import org.spockframework.mock.runtime.JavaMockInterceptor;
import org.spockframework.mock.runtime.MockConfiguration;
import org.spockframework.mock.runtime.MockCreationSettings;
import org.spockframework.mock.runtime.MockMakerRegistry;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.RunContext;
import org.spockframework.util.ReflectionUtil;
import org.spockframework.util.SpockDocLinks;
import spock.lang.Specification;

public class JavaMockFactory
implements IMockFactory {
    public static final JavaMockFactory INSTANCE = new JavaMockFactory();

    @Override
    public boolean canCreate(IMockConfiguration configuration) {
        return configuration.getImplementation() == MockImplementation.JAVA;
    }

    @Override
    public Object create(IMockConfiguration configuration, Specification specification) {
        return this.createInternal(configuration, specification, specification.getClass().getClassLoader());
    }

    @Override
    public Object createDetached(IMockConfiguration configuration, ClassLoader classLoader) {
        return this.createInternal(configuration, null, classLoader);
    }

    private Object createInternal(IMockConfiguration configuration, Specification specification, ClassLoader classLoader) {
        Class<?> type = configuration.getType();
        JavaMockFactory.checkNotGlobal(configuration);
        MetaClass mockMetaClass = GroovyRuntimeUtil.getMetaClass(type);
        JavaMockInterceptor interceptor = new JavaMockInterceptor(configuration, specification, mockMetaClass);
        Object proxy = this.getMockMakerRegistry().makeMock(MockCreationSettings.settingsFromMockConfiguration(configuration, interceptor, classLoader));
        List<Class<?>> additionalInterfaces = configuration.getAdditionalInterfaces();
        if (!additionalInterfaces.isEmpty() && GroovyObject.class.isAssignableFrom(type)) {
            interceptor.setMetaClass(GroovyRuntimeUtil.getMetaClass(proxy.getClass()));
        }
        if (configuration.getNature() == MockNature.SPY && configuration.getInstance() != null) {
            try {
                ReflectionUtil.deepCopyFields(configuration.getInstance(), proxy);
            }
            catch (Exception e) {
                throw new CannotCreateMockException(type, ". Cannot copy fields.\n" + SpockDocLinks.SPY_ON_JAVA_17.getLink(), e);
            }
        }
        return proxy;
    }

    private MockMakerRegistry getMockMakerRegistry() {
        return RunContext.get().getMockMakerRegistry();
    }

    private static void checkNotGlobal(IMockConfiguration configuration) {
        if (configuration.isGlobal()) {
            throw new CannotCreateMockException(configuration.getType(), " because Java mocks cannot mock globally. If the code under test is written in Groovy, use a Groovy mock.");
        }
    }

    public void createStaticMock(MockConfiguration configuration, Specification specification) {
        JavaMockFactory.checkNotGlobal(configuration);
        MetaClass mockMetaClass = GroovyRuntimeUtil.getMetaClass(configuration.getType());
        JavaMockInterceptor interceptor = new JavaMockInterceptor(configuration, specification, mockMetaClass);
        MockCreationSettings creationSettings = MockCreationSettings.settingsFromMockConfigurationForStaticMock(configuration, interceptor, specification.getClass().getClassLoader());
        IMockMaker.IStaticMock mockMakerStaticMock = this.getMockMakerRegistry().makeStaticMock(creationSettings);
        mockMakerStaticMock.enable();
        ISpecificationContext specificationContext = specification.getSpecificationContext();
        specificationContext.getCurrentIteration().addCleanup(mockMakerStaticMock::disable);
        specificationContext.getThreadAwareMockController().registerStaticMock(mockMakerStaticMock);
    }
}

