/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import org.spockframework.mock.IInteractionScope;
import org.spockframework.mock.IMockController;
import org.spockframework.mock.IMockInteraction;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.IThreadAwareMockController;
import org.spockframework.mock.InteractionNotSatisfiedError;
import org.spockframework.mock.runtime.IMockMaker;
import org.spockframework.mock.runtime.InteractionScope;
import org.spockframework.util.ExceptionUtil;

public class MockController
implements IMockController,
IThreadAwareMockController {
    private final Deque<IInteractionScope> scopes = new LinkedList<IInteractionScope>();
    private final List<InteractionNotSatisfiedError> errors = new CopyOnWriteArrayList<InteractionNotSatisfiedError>();
    private final List<IMockMaker.IStaticMock> staticMocks = new ArrayList<IMockMaker.IStaticMock>();
    public static final String ADD_INTERACTION = "addInteraction";
    public static final String ADD_BARRIER = "addBarrier";
    public static final String ENTER_SCOPE = "enterScope";
    public static final String LEAVE_SCOPE = "leaveScope";

    public MockController() {
        this.scopes.addFirst(new InteractionScope());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object handle(IMockInvocation invocation) {
        Supplier<Object> resultSupplier = null;
        MockController mockController = this;
        synchronized (mockController) {
            for (IInteractionScope scope : this.scopes) {
                IMockInteraction interaction = scope.match(invocation);
                if (interaction == null) continue;
                resultSupplier = Objects.requireNonNull(interaction.accept(invocation), "interaction must not return null");
                break;
            }
            if (resultSupplier == null) {
                for (IInteractionScope scope : this.scopes) {
                    scope.addUnmatchedInvocation(invocation);
                }
            }
        }
        if (resultSupplier == null) {
            return invocation.getMockObject().getDefaultResponse().getResponseSupplier(invocation).get();
        }
        try {
            return resultSupplier.get();
        }
        catch (InteractionNotSatisfiedError e) {
            this.errors.add(e);
            throw e;
        }
    }

    public synchronized void addInteraction(IMockInteraction interaction) {
        this.scopes.getFirst().addInteraction(interaction);
    }

    public synchronized void addBarrier() {
        this.scopes.getFirst().addOrderingBarrier();
    }

    public synchronized void enterScope() {
        this.throwAnyPreviousError();
        this.scopes.addFirst(new InteractionScope());
    }

    public synchronized void leaveScope() {
        this.throwAnyPreviousError();
        IInteractionScope scope = this.scopes.removeFirst();
        scope.verifyInteractions();
    }

    private void throwAnyPreviousError() {
        if (!this.errors.isEmpty()) {
            throw this.errors.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerStaticMock(IMockMaker.IStaticMock staticMock) {
        List<IMockMaker.IStaticMock> list = this.staticMocks;
        synchronized (list) {
            this.staticMocks.add(Objects.requireNonNull(staticMock));
        }
    }

    private void enableThreadAwareMocksOnCurrentThread() {
        this.enableStaticMocksOnCurrentThread();
    }

    private void disableThreadAwareMocksOnCurrentThread() {
        this.disableStaticMocksOnCurrentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableStaticMocksOnCurrentThread() {
        List<IMockMaker.IStaticMock> list = this.staticMocks;
        synchronized (list) {
            for (IMockMaker.IStaticMock mock : this.staticMocks) {
                mock.enable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableStaticMocksOnCurrentThread() {
        List<IMockMaker.IStaticMock> list = this.staticMocks;
        synchronized (list) {
            for (IMockMaker.IStaticMock mock : this.staticMocks) {
                mock.disable();
            }
        }
    }

    @Override
    public void runWithThreadAwareMocks(Runnable code) {
        this.enableThreadAwareMocksOnCurrentThread();
        try {
            code.run();
        }
        finally {
            this.disableThreadAwareMocksOnCurrentThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R withActiveThreadAwareMocks(Callable<R> code) {
        this.enableThreadAwareMocksOnCurrentThread();
        try {
            R r = code.call();
            return r;
        }
        catch (Exception ex) {
            Object r = ExceptionUtil.sneakyThrow(ex);
            return r;
        }
        finally {
            this.disableThreadAwareMocksOnCurrentThread();
        }
    }
}

