/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.spockframework.mock.IMockConfiguration;
import org.spockframework.mock.MockNature;
import org.spockframework.mock.runtime.IMockMaker;
import org.spockframework.mock.runtime.IProxyBasedMockInterceptor;
import org.spockframework.util.ObjectUtil;
import spock.mock.IMockMakerSettings;

public class MockCreationSettings
implements IMockMaker.IMockCreationSettings {
    private final IMockMakerSettings mockMakerSettings;
    private final Class<?> mockType;
    private final ClassLoader classLoader;
    private final boolean useObjenesis;
    private final List<Class<?>> additionalInterfaces;
    private final List<Object> constructorArgs;
    private final IProxyBasedMockInterceptor mockInterceptor;
    private final MockNature mockNature;
    private final boolean staticMock;

    public static MockCreationSettings settingsFromMockConfiguration(IMockConfiguration mockConfig, IProxyBasedMockInterceptor interceptor, ClassLoader classLoader) {
        return new MockCreationSettings(mockConfig.getMockMaker(), mockConfig.getType(), mockConfig.getNature(), new ArrayList(mockConfig.getAdditionalInterfaces()), mockConfig.getConstructorArgs(), interceptor, classLoader, mockConfig.isUseObjenesis(), false);
    }

    public static MockCreationSettings settingsFromMockConfigurationForStaticMock(IMockConfiguration mockConfig, IProxyBasedMockInterceptor interceptor, ClassLoader classLoader) {
        return new MockCreationSettings(mockConfig.getMockMaker(), mockConfig.getType(), mockConfig.getNature(), Collections.emptyList(), null, interceptor, classLoader, false, true);
    }

    public static MockCreationSettings settings(Class<?> mockType, List<Class<?>> additionalInterfaces, IProxyBasedMockInterceptor interceptor, ClassLoader classLoader, boolean useObjenesis) {
        return new MockCreationSettings(null, mockType, MockNature.MOCK, additionalInterfaces, null, interceptor, classLoader, useObjenesis, false);
    }

    private MockCreationSettings(IMockMakerSettings mockMakerSettings, Class<?> mockType, MockNature mockNature, List<Class<?>> additionalInterfaces, List<Object> constructorArgs, IProxyBasedMockInterceptor mockInterceptor, ClassLoader classLoader, boolean useObjenesis, boolean staticMock) {
        this.mockMakerSettings = mockMakerSettings;
        this.mockType = Objects.requireNonNull(mockType);
        this.mockNature = Objects.requireNonNull(mockNature);
        this.classLoader = classLoader;
        this.useObjenesis = useObjenesis;
        this.additionalInterfaces = additionalInterfaces;
        this.constructorArgs = constructorArgs;
        this.mockInterceptor = mockInterceptor;
        this.staticMock = staticMock;
    }

    @Override
    public Class<?> getMockType() {
        return this.mockType;
    }

    @Override
    public MockNature getMockNature() {
        return this.mockNature;
    }

    @Override
    public List<Class<?>> getAdditionalInterface() {
        return this.additionalInterfaces;
    }

    @Override
    public List<Object> getConstructorArgs() {
        return this.constructorArgs;
    }

    @Override
    public IProxyBasedMockInterceptor getMockInterceptor() {
        return this.mockInterceptor;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public boolean isUseObjenesis() {
        return this.useObjenesis;
    }

    @Override
    public boolean isStaticMock() {
        return this.staticMock;
    }

    @Override
    public <T extends IMockMakerSettings> T getMockMakerSettings() {
        return (T)((IMockMakerSettings)ObjectUtil.uncheckedCast(this.mockMakerSettings));
    }
}

