/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.spockframework.mock.CannotCreateMockException;
import org.spockframework.mock.IMockObject;
import org.spockframework.mock.ISpockMockObject;
import org.spockframework.mock.runtime.IMockMaker;
import org.spockframework.mock.runtime.MockMakerConfiguration;
import org.spockframework.util.InternalSpockError;
import spock.mock.IMockMakerSettings;
import spock.mock.MockMakerId;

public final class MockMakerRegistry {
    private static final String NL = "\n";
    private static final int PREFERRED_MOCK_MAKER_PRIORITY = 0;
    private final Map<MockMakerId, IMockMaker> makerMap = new HashMap<MockMakerId, IMockMaker>();
    private final List<IMockMaker> makerList = new ArrayList<IMockMaker>();

    public static MockMakerRegistry createFromServiceLoader(MockMakerConfiguration configuration) {
        ServiceLoader<IMockMaker> mockMakers = ServiceLoader.load(IMockMaker.class);
        return new MockMakerRegistry(mockMakers, configuration.preferredMockMaker);
    }

    MockMakerRegistry(Iterable<IMockMaker> mockMakers, IMockMakerSettings preferredMockMakerParam) {
        MockMakerId preferredMockMakerId;
        mockMakers.forEach(m -> {
            MockMakerRegistry.validateMockMakerId(m);
            if (m.getCapabilities() == null || m.getCapabilities().isEmpty()) {
                throw new IllegalStateException("The IMockMaker '" + m + "' does not define any capability.");
            }
            IMockMaker old = this.makerMap.put(m.getId(), (IMockMaker)m);
            if (old != null) {
                throw new IllegalStateException("Duplicated IMockMaker instances with the same ID found: " + m.getId());
            }
            this.makerList.add((IMockMaker)m);
        });
        if (this.makerList.isEmpty()) {
            throw new InternalSpockError("No IMockMaker implementations found.");
        }
        if (preferredMockMakerParam != null) {
            preferredMockMakerId = preferredMockMakerParam.getMockMakerId();
            if (this.makerMap.get(preferredMockMakerParam.getMockMakerId()) == null) {
                throw new IllegalStateException("No IMockMaker with ID '" + preferredMockMakerId + "' exists, but was request via mockMaker.preferredMockMaker configuration. Is a runtime dependency missing?");
            }
        } else {
            preferredMockMakerId = null;
        }
        this.makerList.sort(Comparator.comparing(maker -> {
            if (Objects.equals(maker.getId(), preferredMockMakerId)) {
                return 0;
            }
            return maker.getPriority();
        }).thenComparing(IMockMaker::getId));
    }

    private static void validateMockMakerId(IMockMaker mockMaker) {
        MockMakerId id = mockMaker.getId();
        if (id == null) {
            throw new IllegalStateException("The IMockMaker '" + mockMaker.getClass().getName() + "' has an invalid ID. The ID must not be null.");
        }
        int priority = mockMaker.getPriority();
        if (priority < 0) {
            throw new IllegalStateException("The IMockMaker '" + id + "' has an invalid priority " + priority + ". Priorities < 0 are invalid.");
        }
        if (priority == 0) {
            throw new IllegalStateException("The IMockMaker '" + id + "' has an invalid priority " + priority + ". The priority " + priority + " is reserved.");
        }
    }

    public List<IMockMaker> getMakerList() {
        return Collections.unmodifiableList(this.makerList);
    }

    public Object makeMock(IMockMaker.IMockCreationSettings settings) throws CannotCreateMockException {
        if (settings.isStaticMock()) {
            throw new IllegalArgumentException("Can't mock static mocks with makeMock().");
        }
        return this.makeMockInternal(settings, IMockMaker::makeMock);
    }

    public IMockMaker.IStaticMock makeStaticMock(IMockMaker.IMockCreationSettings settings) throws CannotCreateMockException {
        if (!settings.isStaticMock()) {
            throw new IllegalArgumentException("Can't mock instance mocks with makeStaticMock().");
        }
        return this.makeMockInternal(settings, IMockMaker::makeStaticMock);
    }

    public <T> T makeMockInternal(IMockMaker.IMockCreationSettings settings, BiFunction<IMockMaker, IMockMaker.IMockCreationSettings, T> code) throws CannotCreateMockException {
        Object mockMakerSettings = settings.getMockMakerSettings();
        if (mockMakerSettings != null) {
            MockMakerId mockMakerId = mockMakerSettings.getMockMakerId();
            IMockMaker mockMaker = this.makerMap.get(mockMakerId);
            if (mockMaker == null) {
                throw new CannotCreateMockException(settings.getMockType(), " because MockMaker with ID '" + mockMakerId + "' does not exist.");
            }
            this.verifyIsMockable(mockMaker, settings);
            return code.apply(mockMaker, settings);
        }
        return this.createWithAppropriateMockMaker(settings, code);
    }

    public IMockObject asMockOrNull(Object object) {
        if (object instanceof ISpockMockObject) {
            return ((ISpockMockObject)object).$spock_get();
        }
        for (IMockMaker mockMaker : this.makerList) {
            IMockObject mock = mockMaker.asMockOrNull(object);
            if (mock == null) continue;
            return mock;
        }
        return null;
    }

    public boolean isStaticMock(Class<?> clazz) {
        Objects.requireNonNull(clazz);
        for (IMockMaker mockMaker : this.makerList) {
            if (!mockMaker.isStaticMock(clazz)) continue;
            return true;
        }
        return false;
    }

    private <T> T createWithAppropriateMockMaker(IMockMaker.IMockCreationSettings settings, BiFunction<IMockMaker, IMockMaker.IMockCreationSettings, T> code) {
        for (IMockMaker mockMaker : this.makerList) {
            if (!this.isMockable(mockMaker, settings).isMockable()) continue;
            return code.apply(mockMaker, settings);
        }
        IMockMaker.IMockabilityResult typeMockable = this.collectNotMockableReasons(settings);
        throw new CannotCreateMockException(settings.getMockType(), ".\n" + typeMockable.getNotMockableReason());
    }

    private void verifyIsMockable(IMockMaker mockMaker, IMockMaker.IMockCreationSettings settings) {
        IMockMaker.IMockabilityResult result = this.isMockable(mockMaker, settings);
        if (!result.isMockable()) {
            throw new CannotCreateMockException(settings.getMockType(), ". " + mockMaker.getId() + ": " + result.getNotMockableReason());
        }
    }

    private IMockMaker.IMockabilityResult collectNotMockableReasons(IMockMaker.IMockCreationSettings settings) {
        return () -> this.makerList.stream().map(m -> {
            IMockMaker.IMockabilityResult result = this.isMockable((IMockMaker)m, settings);
            if (!result.isMockable()) {
                return m.getId() + ": " + result.getNotMockableReason();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.joining(NL));
    }

    private IMockMaker.IMockabilityResult isMockable(IMockMaker mockMaker, IMockMaker.IMockCreationSettings settings) {
        Set<IMockMaker.MockMakerCapability> capabilities = mockMaker.getCapabilities();
        Class<?> mockType = settings.getMockType();
        if (mockType.isInterface() && !capabilities.contains((Object)IMockMaker.MockMakerCapability.INTERFACE)) {
            return IMockMaker.MockMakerCapability.INTERFACE.notMockable();
        }
        if (!mockType.isInterface() && !capabilities.contains((Object)IMockMaker.MockMakerCapability.CLASS)) {
            return IMockMaker.MockMakerCapability.CLASS.notMockable();
        }
        if (!settings.getAdditionalInterface().isEmpty() && !capabilities.contains((Object)IMockMaker.MockMakerCapability.ADDITIONAL_INTERFACES)) {
            return IMockMaker.MockMakerCapability.ADDITIONAL_INTERFACES.notMockable();
        }
        if (settings.getConstructorArgs() != null && !capabilities.contains((Object)IMockMaker.MockMakerCapability.EXPLICIT_CONSTRUCTOR_ARGUMENTS)) {
            return IMockMaker.MockMakerCapability.EXPLICIT_CONSTRUCTOR_ARGUMENTS.notMockable();
        }
        if (Modifier.isFinal(mockType.getModifiers()) && !capabilities.contains((Object)IMockMaker.MockMakerCapability.FINAL_CLASS)) {
            return IMockMaker.MockMakerCapability.FINAL_CLASS.notMockable();
        }
        if (settings.isStaticMock() && !capabilities.contains((Object)IMockMaker.MockMakerCapability.STATIC_METHOD)) {
            return IMockMaker.MockMakerCapability.STATIC_METHOD.notMockable();
        }
        return mockMaker.getMockability(settings);
    }
}

