/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime.mockito;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Supplier;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.MockitoFramework;
import org.mockito.creation.instance.InstantiationException;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.util.MockUtil;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.InvocationContainer;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.mockito.plugins.MockMaker;
import org.mockito.plugins.MockitoPlugins;
import org.spockframework.mock.CannotCreateMockException;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.IMockObject;
import org.spockframework.mock.IResponseGenerator;
import org.spockframework.mock.ISpockMockObject;
import org.spockframework.mock.MockNature;
import org.spockframework.mock.runtime.IMockMaker;
import org.spockframework.mock.runtime.IProxyBasedMockInterceptor;
import org.spockframework.mock.runtime.mockito.MockitoMockMaker;
import org.spockframework.mock.runtime.mockito.MockitoMockMakerSettings;
import org.spockframework.util.ExceptionUtil;
import org.spockframework.util.ObjectUtil;
import org.spockframework.util.ReflectionUtil;

class MockitoMockMakerImpl {
    private static final Class<?>[] CLASS_ARRAY = new Class[0];
    private final MockMaker inlineMockMaker = this.resolveInlineMockMaker();
    private final Method spockMockMethod = ReflectionUtil.getMethodByName(ISpockMockObject.class, "$spock_get");

    MockitoMockMakerImpl() {
    }

    private MockMaker resolveInlineMockMaker() {
        MockitoFramework framework = Mockito.framework();
        MockitoPlugins plugins = framework.getPlugins();
        try {
            MockMaker mockMaker = (MockMaker)InvokerHelper.invokeMethod((Object)plugins, (String)"getMockMaker", (Object)"mock-maker-inline");
            return Objects.requireNonNull(mockMaker);
        }
        catch (Exception ignored) {
            try {
                MockMaker mockMaker = (MockMaker)InvokerHelper.invokeStaticMethod(MockUtil.class, (String)"getMockMaker", (Object)"mock-maker-inline");
                return Objects.requireNonNull(mockMaker);
            }
            catch (Exception ignored2) {
                return plugins.getInlineMockMaker();
            }
        }
    }

    IMockObject asMockOrNull(Object object) {
        MockHandler mockHandler = this.inlineMockMaker.getHandler(object);
        if (mockHandler instanceof SpockMockHandler) {
            SpockMockHandler spockHandler = (SpockMockHandler)mockHandler;
            return (IMockObject)spockHandler.mockInterceptor.intercept(object, this.spockMockMethod, null, null);
        }
        return null;
    }

    public boolean isStaticMock(Class<?> clazz) {
        Objects.requireNonNull(clazz);
        MockHandler mockHandler = this.inlineMockMaker.getHandler(clazz);
        return mockHandler instanceof SpockMockHandler;
    }

    Object makeMock(IMockMaker.IMockCreationSettings settings) throws CannotCreateMockException {
        try {
            MockSettings mockitoSettings = Mockito.withSettings();
            mockitoSettings.mockMaker("mock-maker-inline");
            if (!settings.getAdditionalInterface().isEmpty()) {
                mockitoSettings.extraInterfaces((Class[])settings.getAdditionalInterface().toArray(CLASS_ARRAY));
            }
            if (settings.getConstructorArgs() != null) {
                mockitoSettings.useConstructor(settings.getConstructorArgs().toArray());
            } else if (settings.getMockNature() == MockNature.SPY) {
                mockitoSettings.useConstructor(new Object[0]);
            }
            mockitoSettings.stubOnly();
            MockitoMockMakerImpl.applyMockMakerSettingsFromUser(settings, mockitoSettings);
            MockCreationSettings mockitoCreationSettings = mockitoSettings.build(settings.getMockType());
            SpockMockHandler handler = new SpockMockHandler(settings.getMockInterceptor());
            return this.inlineMockMaker.createMock(mockitoCreationSettings, (MockHandler)handler);
        }
        catch (MockitoException ex) {
            throw MockitoMockMakerImpl.cannotCreateMockException(settings.getMockType(), ex);
        }
    }

    private static void applyMockMakerSettingsFromUser(IMockMaker.IMockCreationSettings settings, MockSettings mockitoSettings) {
        Object mockMakerSettings = settings.getMockMakerSettings();
        if (mockMakerSettings instanceof MockitoMockMakerSettings) {
            MockitoMockMakerSettings mockitoMakerSettings = (MockitoMockMakerSettings)mockMakerSettings;
            mockitoMakerSettings.applySettings(mockitoSettings);
        }
    }

    public IMockMaker.IMockabilityResult isMockable(Class<?> mockType) {
        MockMaker.TypeMockability result = this.inlineMockMaker.isTypeMockable(mockType);
        if (result.mockable()) {
            return IMockMaker.IMockabilityResult.MOCKABLE;
        }
        return () -> ((MockMaker.TypeMockability)result).nonMockableReason();
    }

    public IMockMaker.IStaticMock makeStaticMock(IMockMaker.IMockCreationSettings settings) {
        try {
            MockSettings mockitoSettings = Mockito.withSettings();
            mockitoSettings.mockMaker("mock-maker-inline");
            mockitoSettings.stubOnly();
            MockitoMockMakerImpl.applyMockMakerSettingsFromUser(settings, mockitoSettings);
            Class<?> type = settings.getMockType();
            MockCreationSettings mockitoCreationSettings = mockitoSettings.build((Class)ObjectUtil.uncheckedCast(type));
            SpockMockHandler handler = new SpockMockHandler(settings.getMockInterceptor());
            return new MockitoStaticMock(type, () -> this.inlineMockMaker.createStaticMock((Class)ObjectUtil.uncheckedCast(type), mockitoCreationSettings, (MockHandler)handler));
        }
        catch (MockitoException ex) {
            throw MockitoMockMakerImpl.cannotCreateMockException(settings.getMockType(), ex);
        }
    }

    private static CannotCreateMockException cannotCreateMockException(Class<?> mockType, MockitoException ex) {
        String mockitoMessage = MockitoMockMakerImpl.extractMockitoExceptionMessage(ex);
        return new CannotCreateMockException(mockType, " with " + MockitoMockMaker.ID + ": " + mockitoMessage, ex);
    }

    private static String extractMockitoExceptionMessage(MockitoException ex) {
        Throwable exToUse = ex;
        if (ex.getCause() instanceof InstantiationException) {
            exToUse = ex.getCause();
        }
        return exToUse.getMessage().trim();
    }

    private static final class SpockMockHandler
    implements MockHandler<Object> {
        private final IProxyBasedMockInterceptor mockInterceptor;

        public SpockMockHandler(IProxyBasedMockInterceptor mockInterceptor) {
            this.mockInterceptor = mockInterceptor;
        }

        public Object handle(final Invocation invocation) {
            Object mock = invocation.getMock();
            return this.mockInterceptor.intercept(mock, invocation.getMethod(), invocation.getArguments(), new IResponseGenerator(){

                @Override
                public Object respond(IMockInvocation __) {
                    try {
                        return invocation.callRealMethod();
                    }
                    catch (Throwable e) {
                        return ExceptionUtil.sneakyThrow(e);
                    }
                }
            });
        }

        public MockCreationSettings<Object> getMockSettings() {
            throw new UnsupportedOperationException();
        }

        public InvocationContainer getInvocationContainer() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class MockitoStaticMock
    implements IMockMaker.IStaticMock {
        private final Class<?> type;
        private final ThreadLocal<MockThreadData> threadData;

        MockitoStaticMock(Class<?> type, Supplier<MockMaker.StaticMockControl<Object>> staticMockControlCreation) {
            Objects.requireNonNull(staticMockControlCreation);
            this.type = Objects.requireNonNull(type);
            this.threadData = ThreadLocal.withInitial(() -> new MockThreadData(staticMockControlCreation));
            this.threadLocalMockData();
        }

        private MockThreadData threadLocalMockData() {
            try {
                return this.threadData.get();
            }
            catch (MockitoException ex) {
                throw MockitoMockMakerImpl.cannotCreateMockException(this.getType(), ex);
            }
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public void enable() {
            this.threadLocalMockData().enable();
        }

        @Override
        public void disable() {
            if (this.threadLocalMockData().disable()) {
                this.threadData.remove();
            }
        }

        private static class MockThreadData {
            private final MockMaker.StaticMockControl<Object> mockControl;
            private int activations;

            MockThreadData(Supplier<MockMaker.StaticMockControl<Object>> staticMockControlCreation) {
                this.mockControl = staticMockControlCreation.get();
            }

            void enable() {
                if (this.activations == 0) {
                    try {
                        this.mockControl.enable();
                    }
                    catch (MockitoException ex) {
                        throw MockitoMockMakerImpl.cannotCreateMockException(this.mockControl.getType(), ex);
                    }
                }
                ++this.activations;
                if (this.activations < 0) {
                    throw new IllegalStateException("Activations overflowed.");
                }
            }

            boolean disable() {
                --this.activations;
                if (this.activations < 0) {
                    throw new IllegalStateException("disable() called, but there is no activation on the current thread.");
                }
                if (this.activations == 0) {
                    try {
                        this.mockControl.disable();
                        return true;
                    }
                    catch (MockitoException ex) {
                        throw MockitoMockMakerImpl.cannotCreateMockException(this.mockControl.getType(), ex);
                    }
                }
                return false;
            }
        }
    }
}

