/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.spockframework.runtime.extension.ExtensionException;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.util.ReflectionUtil;
import spock.config.ConfigurationObject;

public class ExtensionClassesLoader {
    public static final String EXTENSION_DESCRIPTOR_PATH = "META-INF/services/" + IGlobalExtension.class.getName();
    public static final String CONFIG_DESCRIPTOR_PATH = "META-INF/services/" + ConfigurationObject.class.getName();

    public List<Class<? extends IGlobalExtension>> loadExtensionClassesFromDefaultLocation() {
        return this.loadClasses(EXTENSION_DESCRIPTOR_PATH, IGlobalExtension.class);
    }

    public List<Class<?>> loadConfigClassesFromDefaultLocation() {
        return this.loadClasses(CONFIG_DESCRIPTOR_PATH, Object.class);
    }

    public <T> List<Class<? extends T>> loadClasses(String descriptorPath, Class<T> baseClass) {
        HashMap<String, URL> discoveredClasses = new HashMap<String, URL>();
        ArrayList<Class<T>> extClasses = new ArrayList<Class<T>>();
        for (URL url : this.locateDescriptors(descriptorPath)) {
            for (String className : this.readDescriptor(url)) {
                if (discoveredClasses.containsKey(className)) {
                    throw new ExtensionException("Duplicated Extension declaration for [%s]\nSource 1: %s\nSource 2: %s\nThis is most likely caused by having two different version of a library on the classpath.").withArgs(className, url, discoveredClasses.get(className));
                }
                discoveredClasses.put(className, url);
                extClasses.add(this.loadExtensionClass(className, baseClass));
            }
        }
        return extClasses;
    }

    private Collection<URL> locateDescriptors(String descriptorPath) {
        try {
            return ReflectionUtil.getResourcesFromClassLoader(descriptorPath);
        }
        catch (Exception e) {
            throw new ExtensionException("Failed to locate extension descriptors", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> readDescriptor(URL url) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            ArrayList<String> lines = new ArrayList<String>();
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                    lines.add(line);
                }
                line = reader.readLine();
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        catch (IOException e) {
            throw new ExtensionException("Failed to read extension descriptor '%s'", e).withArgs(url);
        }
    }

    private <T> Class<? extends T> loadExtensionClass(String className, Class<T> baseClass) {
        try {
            Class<?> loadedClass = ReflectionUtil.loadClass(className);
            if (!baseClass.isAssignableFrom(loadedClass)) {
                throw new ExtensionException("Failed to load extension class '%s' as it is not assignable to '%s'").withArgs(className, baseClass.getName());
            }
            return loadedClass;
        }
        catch (Exception e) {
            throw new ExtensionException("Failed to load extension class '%s'", e).withArgs(className);
        }
    }
}

