/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.Objects;
import org.spockframework.runtime.ExpressionComparisonRenderer;
import org.spockframework.runtime.ExpressionInfoValueRenderer;
import org.spockframework.runtime.model.ExpressionInfo;
import org.spockframework.util.ObjectUtil;

public class FailedEqualityComparisonRenderer
implements ExpressionComparisonRenderer {
    @Override
    public String render(ExpressionInfo expr) {
        if (!Boolean.FALSE.equals(expr.getValue())) {
            return null;
        }
        if (!expr.isEqualityComparison()) {
            return null;
        }
        ExpressionInfo expr1 = expr.getChildren().get(0);
        ExpressionInfo expr2 = expr.getChildren().get(1);
        if (expr1.getRenderedValue() == null) {
            this.renderIrrelevant(expr1);
        }
        if (expr2.getRenderedValue() == null) {
            this.renderIrrelevant(expr2);
        }
        if (Objects.equals(expr1.getRenderedValue(), expr2.getRenderedValue())) {
            this.addTypeHints(expr1, expr2);
            expr1.setRelevant(true);
            expr2.setRelevant(true);
        }
        return "false";
    }

    private void addTypeHints(ExpressionInfo expr1, ExpressionInfo expr2) {
        String expr2TypeHint;
        String expr1RenderedValue = expr1.getRenderedValue();
        if (expr1RenderedValue == null) {
            return;
        }
        String expr1TypeHint = this.getTypeHint(expr1);
        if (expr1TypeHint.equals(expr2TypeHint = this.getTypeHint(expr2))) {
            expr1TypeHint = expr1TypeHint + "@" + Integer.toHexString(System.identityHashCode(expr1.getValue()));
            expr2TypeHint = expr2TypeHint + "@" + Integer.toHexString(System.identityHashCode(expr2.getValue()));
        }
        expr1.setRenderedValue(expr1RenderedValue + " (" + expr1TypeHint + ")");
        expr2.setRenderedValue(expr2.getRenderedValue() + " (" + expr2TypeHint + ")");
    }

    private String getTypeHint(ExpressionInfo expr) {
        Class<?> exprType = ObjectUtil.voidAwareGetClass(expr.getValue());
        String typeName = exprType.getCanonicalName();
        return typeName == null ? exprType.getName() : typeName;
    }

    private void renderIrrelevant(ExpressionInfo irrelevantExpr) {
        for (ExpressionInfo expr : irrelevantExpr.inPostfixOrder(false)) {
            if (expr.isRelevant() || expr.getRenderedValue() != null) continue;
            expr.setRenderedValue(ExpressionInfoValueRenderer.renderValue(expr));
        }
    }
}

