/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;
import org.spockframework.runtime.ErrorInfoCollector;
import org.spockframework.runtime.SpecNode;
import org.spockframework.runtime.SpockExecutionContext;
import org.spockframework.runtime.SpockNode;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.ISkippable;
import org.spockframework.runtime.model.TestTag;
import spock.config.RunnerConfiguration;

public abstract class FeatureNode
extends SpockNode<FeatureInfo> {
    protected boolean removedFromHierarchy = false;

    public FeatureNode(UniqueId uniqueId, String displayName, TestSource source, RunnerConfiguration configuration, FeatureInfo featureInfo) {
        super(uniqueId, displayName, source, configuration, featureInfo);
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public Set<org.junit.platform.engine.TestTag> getTags() {
        return ((FeatureInfo)this.getNodeInfo()).getTestTags().stream().map(TestTag::getValue).map(org.junit.platform.engine.TestTag::create).collect(Collectors.toSet());
    }

    public Node.SkipResult shouldBeSkipped(SpockExecutionContext context) throws Exception {
        return this.shouldBeSkipped((ISkippable)this.getNodeInfo());
    }

    public void nodeSkipped(SpockExecutionContext context, TestDescriptor testDescriptor, Node.SkipResult result) {
        context.getRunner().supervisor.featureSkipped((FeatureInfo)this.getNodeInfo());
    }

    public SpockExecutionContext prepare(SpockExecutionContext context) throws Exception {
        return context.withChildStoreProvider();
    }

    public void around(SpockExecutionContext context, Node.Invocation<SpockExecutionContext> invocation) {
        context.getRunContext().ensureInstalled();
        ErrorInfoCollector errorInfoCollector = new ErrorInfoCollector();
        SpockExecutionContext innerContext = context.withErrorInfoCollector(errorInfoCollector);
        context.getRunner().runFeature(innerContext, () -> this.sneakyInvoke(invocation, innerContext));
        errorInfoCollector.assertEmpty();
    }

    public boolean mayRegisterTests() {
        return ((FeatureInfo)this.getNodeInfo()).isParameterized();
    }

    private boolean allImplyingFeaturesAreRemoved() {
        return !this.findFeatureNodes(((FeatureInfo)this.getNodeInfo()).getImplyingFeatures()).findAny().isPresent();
    }

    public void removeFromHierarchy() {
        if (((FeatureInfo)this.getNodeInfo()).getImplyingFeatures().isEmpty() || this.allImplyingFeaturesAreRemoved()) {
            Stream<? extends FeatureNode> impliedFeatureNodes = this.findFeatureNodes(((FeatureInfo)this.getNodeInfo()).getImpliedFeatures());
            super.removeFromHierarchy();
            impliedFeatureNodes.filter(impliedFeature -> impliedFeature.removedFromHierarchy).forEach(TestDescriptor::removeFromHierarchy);
        } else {
            this.removedFromHierarchy = true;
        }
    }

    private Stream<? extends FeatureNode> findFeatureNodes(List<FeatureInfo> features) {
        SpecNode specNode = this.getParent().map(SpecNode.class::cast).orElseThrow(AssertionError::new);
        return features.stream().map(featureInfo -> specNode.getChildren().stream().map(FeatureNode.class::cast).filter(featureNode -> ((FeatureInfo)featureNode.getNodeInfo()).equals(featureInfo)).collect(Collectors.collectingAndThen(Collectors.toList(), featureNodes -> {
            switch (featureNodes.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return (FeatureNode)((Object)((Object)((Object)featureNodes.get(0))));
                }
            }
            throw new AssertionError((Object)"Expected to find 0 or 1 node, but found multiple");
        }))).filter(Objects::nonNull);
    }
}

