/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.transform.Internal;
import java.beans.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.metaclass.MetaClassRegistryImpl;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.GroovyCastException;
import org.spockframework.util.ExceptionUtil;
import org.spockframework.util.ObjectUtil;
import org.spockframework.util.ReflectionUtil;

public abstract class GroovyRuntimeUtil {
    private static final String SET = "set";
    private static final String GET = "get";
    private static final String IS = "is";
    public static Object[] EMPTY_ARGUMENTS = new Object[0];

    public static boolean isTruthy(Object obj) {
        return DefaultTypeTransformation.castToBoolean((Object)obj);
    }

    public static <T> T coerce(Object obj, Class<T> type) {
        return (T)DefaultTypeTransformation.castToType((Object)obj, type);
    }

    @SafeVarargs
    public static <T> T coerce(Object obj, Class<? extends T> ... types) {
        if (types.length == 0) {
            throw new IllegalArgumentException("caller must provide at least one target type");
        }
        GroovyCastException lastException = null;
        for (Class<? extends T> type : types) {
            try {
                return GroovyRuntimeUtil.coerce(obj, type);
            }
            catch (GroovyCastException e) {
                lastException = e;
            }
        }
        throw lastException;
    }

    public static boolean equals(Object obj, Object other) {
        return DefaultTypeTransformation.compareEqual((Object)obj, (Object)other);
    }

    public static String toString(Object obj) {
        return DefaultGroovyMethods.toString((Object)obj);
    }

    public static MetaClass getMetaClass(Object object) {
        return InvokerHelper.getMetaClass((Object)object);
    }

    public static MetaClass getMetaClass(Class<?> clazz) {
        return InvokerHelper.getMetaClass(clazz);
    }

    public static void setMetaClass(Object object, MetaClass metaClass) {
        GroovyObject groovyObject = ObjectUtil.asInstance(object, GroovyObject.class);
        if (groovyObject != null) {
            groovyObject.setMetaClass(metaClass);
            return;
        }
        ((MetaClassRegistryImpl)GroovySystem.getMetaClassRegistry()).setMetaClass(object, metaClass);
    }

    public static void setMetaClass(Class<?> clazz, MetaClass metaClass) {
        GroovySystem.getMetaClassRegistry().setMetaClass(clazz, metaClass);
    }

    public static String propertyToMethodName(String prefix, String propertyName) {
        return prefix + MetaClassHelper.capitalize((String)propertyName);
    }

    public static String propertyToGetterMethodName(String propertyName) {
        return GroovyRuntimeUtil.propertyToMethodName(GET, propertyName);
    }

    public static String propertyToSetterMethodName(String propertyName) {
        return GroovyRuntimeUtil.propertyToMethodName(SET, propertyName);
    }

    public static String propertyToBooleanGetterMethodName(String propertyName) {
        return GroovyRuntimeUtil.propertyToMethodName(IS, propertyName);
    }

    public static String getterMethodToPropertyName(String methodName, List<Class<?>> parameterTypes, Class<?> returnType) {
        if (!parameterTypes.isEmpty()) {
            return null;
        }
        if (returnType == Void.TYPE) {
            return null;
        }
        if (methodName.startsWith(GET)) {
            return GroovyRuntimeUtil.getPropertyName(methodName, 3);
        }
        if (methodName.startsWith(IS) && returnType == Boolean.TYPE) {
            return GroovyRuntimeUtil.getPropertyName(methodName, 2);
        }
        return null;
    }

    private static String getPropertyName(String methodName, int prefixLength) {
        String result = methodName.substring(prefixLength);
        if (result.length() == 0) {
            return null;
        }
        return Introspector.decapitalize(result);
    }

    public static Object getProperty(Object target, String property) {
        try {
            return InvokerHelper.getProperty((Object)target, (String)property);
        }
        catch (InvokerInvocationException e) {
            return ExceptionUtil.sneakyThrow(e.getCause());
        }
    }

    public static void setProperty(Object target, String property, Object value) {
        try {
            InvokerHelper.setProperty((Object)target, (String)property, (Object)value);
        }
        catch (InvokerInvocationException e) {
            ExceptionUtil.sneakyThrow(e.getCause());
        }
    }

    public static Object invokeConstructor(Class<?> clazz, Object ... args) {
        try {
            return InvokerHelper.invokeConstructorOf(clazz, (Object)args);
        }
        catch (InvokerInvocationException e) {
            return ExceptionUtil.sneakyThrow(e.getCause());
        }
    }

    public static Object invokeMethod(Object target, String method, Object ... args) {
        try {
            return InvokerHelper.invokeMethod((Object)target, (String)method, (Object)args);
        }
        catch (InvokerInvocationException e) {
            return ExceptionUtil.sneakyThrow(e.getCause());
        }
    }

    public static Object invokeMethodNullSafe(Object target, String method, Object ... args) {
        try {
            return InvokerHelper.invokeMethodSafe((Object)target, (String)method, (Object)args);
        }
        catch (InvokerInvocationException e) {
            return ExceptionUtil.sneakyThrow(e.getCause());
        }
    }

    public static Object invokeMethodQuietly(Object target, String method, Object ... args) {
        try {
            return InvokerHelper.invokeMethod((Object)target, (String)method, (Object)args);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public static void closeQuietly(Object ... objects) {
        GroovyRuntimeUtil.closeQuietly("close", objects);
    }

    public static void closeQuietly(String closeMethod, Object ... objects) {
        if (objects != null) {
            Arrays.stream(objects).filter(Objects::nonNull).forEach(object -> GroovyRuntimeUtil.invokeMethodQuietly(object, closeMethod, new Object[0]));
        }
    }

    public static <T> T invokeClosure(Closure<T> closure, Object ... args) {
        try {
            return (T)closure.call(args);
        }
        catch (InvokerInvocationException e) {
            return (T)ExceptionUtil.sneakyThrow(e.getCause());
        }
    }

    public static <T extends Closure<?>> T instantiateClosure(Class<T> closureType, Object owner, Object thisObject) {
        try {
            Constructor<T> constructor = closureType.getConstructor(Object.class, Object.class);
            return (T)((Closure)constructor.newInstance(owner, thisObject));
        }
        catch (Exception e) {
            return (T)((Closure)ExceptionUtil.sneakyThrow(e.getCause()));
        }
    }

    public static Iterator<Object> asIterator(Object object) {
        try {
            return InvokerHelper.asIterator((Object)object);
        }
        catch (InvokerInvocationException e) {
            return (Iterator)ExceptionUtil.sneakyThrow(e.getCause());
        }
    }

    public static Object[] asUnwrappedArgumentArray(Object args) {
        return InvokerHelper.asUnwrappedArray((Object)InvokerHelper.asArray((Object)args).clone());
    }

    public static Object[] asArgumentArray(Object args) {
        return InvokerHelper.asArray((Object)args);
    }

    public static List<Object> asArgumentList(Object args) {
        return Arrays.asList(GroovyRuntimeUtil.asArgumentArray(args));
    }

    public static Object[] despreadList(Object[] args, Object[] spreads, int[] positions) {
        return ScriptBytecodeAdapter.despreadList((Object[])args, (Object[])spreads, (int[])positions);
    }

    public static boolean isVoidMethod(Object target, String method, Object ... args) {
        Class[] argTypes;
        if (target == null) {
            return false;
        }
        MetaClass metaClass = target instanceof Class ? InvokerHelper.getMetaClass((Class)((Class)target)) : InvokerHelper.getMetaClass((Object)target);
        MetaMethod metaMethod = metaClass.pickMethod(method, argTypes = ReflectionUtil.getTypes(args));
        if (metaMethod == null) {
            return false;
        }
        Class returnType = metaMethod.getReturnType();
        return returnType == Void.TYPE || returnType == Void.class;
    }

    public static Object getAttribute(Object target, String name) {
        try {
            return InvokerHelper.getAttribute((Object)target, (String)name);
        }
        catch (InvokerInvocationException e) {
            return ExceptionUtil.sneakyThrow(e.getCause());
        }
    }

    public static Method toMethod(MetaMethod metaMethod) {
        CachedMethod cachedMethod = ObjectUtil.asInstance(metaMethod, CachedMethod.class);
        return cachedMethod == null ? null : cachedMethod.getCachedMethod();
    }

    @Internal
    public static boolean isGroovy2() {
        return GroovySystem.getVersion().startsWith("2.");
    }

    @Internal
    public static boolean isGroovy3orNewer() {
        return !GroovyRuntimeUtil.isGroovy2();
    }

    @Internal
    public static boolean isGroovy3orOlder() {
        return GroovyRuntimeUtil.isGroovy2() || GroovySystem.getVersion().startsWith("3.");
    }

    @Internal
    public static boolean isGroovy4orNewer() {
        return !GroovyRuntimeUtil.isGroovy3orOlder();
    }
}

