/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStore;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStoreException;
import org.spockframework.runtime.extension.IStore;
import org.spockframework.util.ObjectUtil;

public class NamespacedExtensionStore
implements IStore {
    private final NamespacedHierarchicalStore<IStore.Namespace> delegate;
    private final Supplier<NamespacedExtensionStore> parentProvider;
    private final IStore.Namespace namespace;

    NamespacedExtensionStore(NamespacedHierarchicalStore<IStore.Namespace> delegate, Supplier<NamespacedExtensionStore> parentProvider, IStore.Namespace namespace) {
        this.delegate = Objects.requireNonNull(delegate);
        this.parentProvider = Objects.requireNonNull(parentProvider);
        this.namespace = Objects.requireNonNull(namespace);
    }

    @Override
    public <V> V get(Object key) {
        return (V)ObjectUtil.uncheckedCast(this.execute(() -> this.delegate.get((Object)this.namespace, key)));
    }

    @Override
    public <V> V get(Object key, Class<V> requiredType) {
        return (V)this.execute(() -> this.delegate.get((Object)this.namespace, key, requiredType));
    }

    @Override
    public <K, V> V getOrComputeIfAbsent(K key, Function<K, V> defaultCreator) {
        return (V)ObjectUtil.uncheckedCast(this.execute(() -> this.delegate.getOrComputeIfAbsent((Object)this.namespace, key, defaultCreator)));
    }

    @Override
    public <K, V> V getOrComputeIfAbsent(K key, Function<K, V> defaultCreator, Class<V> requiredType) {
        return (V)this.execute(() -> this.delegate.getOrComputeIfAbsent((Object)this.namespace, key, defaultCreator, requiredType));
    }

    @Override
    public <V> V put(Object key, Object value) {
        return (V)ObjectUtil.uncheckedCast(this.execute(() -> this.delegate.put((Object)this.namespace, key, value)));
    }

    @Override
    public <V> V remove(Object key) {
        return (V)ObjectUtil.uncheckedCast(this.execute(() -> this.delegate.remove((Object)this.namespace, key)));
    }

    @Override
    public <V> V remove(Object key, Class<V> requiredType) {
        return (V)this.execute(() -> this.delegate.remove((Object)this.namespace, key, requiredType));
    }

    @Override
    public IStore getParentStore() {
        return this.parentProvider.get();
    }

    private <V> V execute(Supplier<V> exec) {
        try {
            return exec.get();
        }
        catch (ClassCastException | NamespacedHierarchicalStoreException e) {
            throw new IStore.StoreException(e.getMessage(), e);
        }
    }
}

