/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.hierarchical.Node;
import org.opentest4j.TestAbortedException;
import org.spockframework.runtime.ParameterizedFeatureNode;
import org.spockframework.runtime.model.ExecutionResult;
import org.spockframework.runtime.model.FeatureInfo;

class ParameterizedFeatureChildExecutor {
    private final ParameterizedFeatureNode parameterizedFeatureNode;
    private final AtomicInteger executionCounter = new AtomicInteger();
    private final Map<TestExecutionResult.Status, Queue<Throwable>> results = new ConcurrentHashMap<TestExecutionResult.Status, Queue<Throwable>>();
    private final Map<TestDescriptor, CompletableFuture<ExecutionResult>> pending = new ConcurrentHashMap<TestDescriptor, CompletableFuture<ExecutionResult>>();
    private final Node.DynamicTestExecutor delegate;
    private final EngineExecutionListener executionListener;

    ParameterizedFeatureChildExecutor(ParameterizedFeatureNode parameterizedFeatureNode, Node.DynamicTestExecutor delegate, final EngineExecutionListener delegateEngineExecutionListener) {
        this.parameterizedFeatureNode = parameterizedFeatureNode;
        this.delegate = delegate;
        this.executionListener = ((FeatureInfo)parameterizedFeatureNode.getNodeInfo()).isReportIterations() ? new EngineExecutionListener(){

            public void dynamicTestRegistered(TestDescriptor testDescriptor) {
                delegateEngineExecutionListener.dynamicTestRegistered(testDescriptor);
            }

            public void executionSkipped(TestDescriptor testDescriptor, String reason) {
                delegateEngineExecutionListener.executionSkipped(testDescriptor, reason);
                ((CompletableFuture)ParameterizedFeatureChildExecutor.this.pending.remove(testDescriptor)).complete(ExecutionResult.ABORTED);
            }

            public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
                ExecutionResult result;
                delegateEngineExecutionListener.executionFinished(testDescriptor, testExecutionResult);
                switch (testExecutionResult.getStatus()) {
                    case SUCCESSFUL: {
                        result = ExecutionResult.SUCCESSFUL;
                        break;
                    }
                    case ABORTED: {
                        result = ExecutionResult.ABORTED;
                        break;
                    }
                    default: {
                        result = ExecutionResult.FAILED;
                    }
                }
                ((CompletableFuture)ParameterizedFeatureChildExecutor.this.pending.remove(testDescriptor)).complete(result);
            }

            public void executionStarted(TestDescriptor testDescriptor) {
                delegateEngineExecutionListener.executionStarted(testDescriptor);
            }

            public void reportingEntryPublished(TestDescriptor testDescriptor, ReportEntry entry) {
                delegateEngineExecutionListener.reportingEntryPublished(testDescriptor, entry);
            }
        } : new EngineExecutionListener(){

            public void executionSkipped(TestDescriptor testDescriptor, String reason) {
                ParameterizedFeatureChildExecutor.this.results.computeIfAbsent(TestExecutionResult.Status.ABORTED, status -> new ConcurrentLinkedQueue()).add(new TestAbortedException(reason));
                ((CompletableFuture)ParameterizedFeatureChildExecutor.this.pending.remove(testDescriptor)).complete(ExecutionResult.ABORTED);
            }

            public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
                Queue failures = ParameterizedFeatureChildExecutor.this.results.computeIfAbsent(testExecutionResult.getStatus(), status -> new ConcurrentLinkedQueue());
                testExecutionResult.getThrowable().ifPresent(failures::add);
                ExecutionResult result = testExecutionResult.getStatus() == TestExecutionResult.Status.SUCCESSFUL ? ExecutionResult.SUCCESSFUL : ExecutionResult.FAILED;
                ((CompletableFuture)ParameterizedFeatureChildExecutor.this.pending.remove(testDescriptor)).complete(result);
            }
        };
    }

    public CompletableFuture<ExecutionResult> execute(TestDescriptor testDescriptor) {
        this.executionCounter.incrementAndGet();
        this.parameterizedFeatureNode.addChild(testDescriptor);
        CompletableFuture<ExecutionResult> future = new CompletableFuture<ExecutionResult>();
        this.pending.put(testDescriptor, future);
        this.delegate.execute(testDescriptor, this.executionListener);
        return future;
    }

    public void awaitFinished() throws InterruptedException {
        this.delegate.awaitFinished();
    }

    int getExecutionCount() {
        return this.executionCounter.get();
    }

    Map<TestExecutionResult.Status, Queue<Throwable>> getResults() {
        return this.results;
    }
}

