/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.concurrent.atomic.AtomicReference;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;
import org.opentest4j.TestAbortedException;
import org.spockframework.runtime.FeatureNode;
import org.spockframework.runtime.IterationNode;
import org.spockframework.runtime.SpockExecutionContext;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.ISkippable;
import org.spockframework.util.ExceptionUtil;
import spock.config.RunnerConfiguration;

public class SimpleFeatureNode
extends FeatureNode {
    private final IterationNode delegate;

    public SimpleFeatureNode(UniqueId uniqueId, RunnerConfiguration configuration, FeatureInfo featureInfo, IterationNode delegate) {
        super(uniqueId, featureInfo.getDisplayName(), (TestSource)SimpleFeatureNode.featureToMethodSource(featureInfo), configuration, featureInfo);
        this.delegate = delegate;
    }

    @Override
    public TestDescriptor.Type getType() {
        return this.delegate.getType();
    }

    @Override
    public SpockExecutionContext prepare(SpockExecutionContext context) throws Exception {
        context = super.prepare(context);
        return context.withCurrentFeature((FeatureInfo)this.getNodeInfo());
    }

    public SpockExecutionContext execute(SpockExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) throws Exception {
        this.verifyNotSkipped((ISkippable)this.getNodeInfo());
        final AtomicReference result = new AtomicReference();
        EngineExecutionListener executionListener = new EngineExecutionListener(){

            public void executionSkipped(TestDescriptor testDescriptor, String reason) {
                result.set(new TestAbortedException(reason));
            }

            public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
                testExecutionResult.getThrowable().ifPresent(result::set);
            }
        };
        this.addChild((TestDescriptor)this.delegate);
        dynamicTestExecutor.execute((TestDescriptor)this.delegate, executionListener);
        dynamicTestExecutor.awaitFinished();
        if (result.get() != null) {
            ExceptionUtil.sneakyThrow((Throwable)result.get());
        }
        return context;
    }
}

