/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.FromString;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.opentest4j.MultipleFailuresError;
import org.spockframework.runtime.Condition;
import org.spockframework.runtime.ConditionFailedWithExceptionError;
import org.spockframework.runtime.ConditionNotSatisfiedError;
import org.spockframework.runtime.ErrorCollector;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.HamcrestFacade;
import org.spockframework.runtime.SpecificationContext;
import org.spockframework.runtime.SpockAssertionError;
import org.spockframework.runtime.SpockException;
import org.spockframework.runtime.SpockMultipleFailuresError;
import org.spockframework.runtime.ValueRecorder;
import org.spockframework.runtime.extension.IBlockListener;
import org.spockframework.runtime.model.BlockInfo;
import org.spockframework.runtime.model.ExpressionInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.TextPosition;
import org.spockframework.util.CollectionUtil;
import org.spockframework.util.ExceptionUtil;
import org.spockframework.util.ReflectionUtil;
import spock.lang.Specification;
import spock.util.matcher.HamcrestSupport;

public abstract class SpockRuntime {
    public static final String VERIFY_CONDITION = "verifyCondition";
    private static final StackTraceElement[] EMPTY_STACK_TRACE_ELEMENTS = new StackTraceElement[0];
    public static final String CONDITION_FAILED_WITH_EXCEPTION = "conditionFailedWithException";
    public static final String GROUP_CONDITION_FAILED_WITH_EXCEPTION = "groupConditionFailedWithException";
    public static final String VERIFY_METHOD_CONDITION = "verifyMethodCondition";
    public static final String MATCH_COLLECTIONS_AS_SET = "matchCollectionsAsSet";
    public static final String MATCH_COLLECTIONS_IN_ANY_ORDER = "matchCollectionsInAnyOrder";
    public static final String DESPREAD_LIST = "despreadList";
    public static final String CALL_BLOCK_ENTERED = "callBlockEntered";
    public static final String CALL_BLOCK_EXITED = "callBlockExited";

    public static void verifyCondition(ErrorCollector errorCollector, ValueRecorder recorder, String text, int line, int column, Object message, Object condition) {
        if (!GroovyRuntimeUtil.isTruthy(condition)) {
            ConditionNotSatisfiedError conditionNotSatisfiedError = new ConditionNotSatisfiedError(new Condition(SpockRuntime.getValues(recorder), text, TextPosition.create(line, column), SpockRuntime.messageToString(message), null, null));
            errorCollector.collectOrThrow(conditionNotSatisfiedError);
        }
    }

    public static void conditionFailedWithException(ErrorCollector errorCollector, ValueRecorder recorder, String text, int line, int column, Object message, Throwable throwable) {
        if (throwable instanceof SpockAssertionError) {
            SpockAssertionError spockAssertionError = (SpockAssertionError)((Object)throwable);
            errorCollector.collectOrThrow(spockAssertionError);
            return;
        }
        if (throwable instanceof SpockException) {
            SpockException spockException = (SpockException)throwable;
            errorCollector.collectOrThrow(spockException);
            return;
        }
        if (throwable instanceof SpockMultipleFailuresError) {
            SpockMultipleFailuresError multipleFailuresError = (SpockMultipleFailuresError)((Object)throwable);
            errorCollector.collectOrThrow(multipleFailuresError);
            return;
        }
        ConditionFailedWithExceptionError conditionNotSatisfiedError = new ConditionFailedWithExceptionError(new Condition(SpockRuntime.getValues(recorder), text, TextPosition.create(line, column), SpockRuntime.messageToString(message), recorder == null ? null : recorder.getCurrentRecordingVarNum(), recorder == null ? null : throwable), throwable);
        errorCollector.collectOrThrow(conditionNotSatisfiedError);
    }

    public static void groupConditionFailedWithException(ErrorCollector errorCollector, Throwable throwable) {
        if (throwable instanceof AssertionError) {
            AssertionError assertionError = (AssertionError)((Object)throwable);
            errorCollector.collectOrThrow(assertionError);
            return;
        }
        if (throwable instanceof SpockException) {
            SpockException spockException = (SpockException)throwable;
            errorCollector.collectOrThrow(spockException);
            return;
        }
        ExceptionUtil.sneakyThrow(throwable);
    }

    public static void verifyMethodCondition(ErrorCollector errorCollector, ValueRecorder recorder, String text, int line, int column, Object message, Object target, String method, Object[] args, boolean safe, boolean explicit, int lastVariableNum) {
        Object result;
        MatcherCondition matcherCondition = MatcherCondition.parse(target, method, args, safe);
        if (matcherCondition != null) {
            matcherCondition.verify(errorCollector, SpockRuntime.getValues(recorder), text, line, column, SpockRuntime.messageToString(message));
            return;
        }
        CollectionCondition collectionCondition = CollectionCondition.parse(target, method, args, safe);
        if (collectionCondition != null) {
            collectionCondition.verify(errorCollector, SpockRuntime.getValues(recorder), text, line, column, SpockRuntime.messageToString(message));
            return;
        }
        if (recorder != null) {
            recorder.startRecordingValue(lastVariableNum);
        }
        Object object = result = safe ? GroovyRuntimeUtil.invokeMethodNullSafe(target, method, args) : GroovyRuntimeUtil.invokeMethod(target, method, args);
        if (!explicit && result == null && SpockRuntime.isVoidMethod(target, method, args)) {
            return;
        }
        if (!GroovyRuntimeUtil.isTruthy(result)) {
            List<Object> values = SpockRuntime.getValues(recorder);
            if (values != null) {
                CollectionUtil.setLastElement(values, result);
            }
            ConditionNotSatisfiedError conditionNotSatisfiedError = new ConditionNotSatisfiedError(new Condition(values, text, TextPosition.create(line, column), SpockRuntime.messageToString(message), null, null));
            errorCollector.collectOrThrow(conditionNotSatisfiedError);
        }
    }

    public static Object matchCollectionsAsSet(Object left, Object right) {
        if (SpockRuntime.isIterableOrArray(left) && SpockRuntime.isIterableOrArray(right)) {
            Set actual = GroovyRuntimeUtil.coerce(left, LinkedHashSet.class);
            Set expected = GroovyRuntimeUtil.coerce(right, LinkedHashSet.class);
            return GroovyRuntimeUtil.equals(actual, expected);
        }
        if (left == null || right == null) {
            return left == null && right == null;
        }
        Pattern pattern = Pattern.compile(String.valueOf(right));
        return pattern.matcher(String.valueOf(left));
    }

    public static boolean matchCollectionsInAnyOrder(Object left, Object right) {
        if (SpockRuntime.isIterableOrArray(left) && SpockRuntime.isIterableOrArray(right)) {
            Object localLeft = SpockRuntime.convertArrayToCollectionIfNecessary(left);
            Object localRight = SpockRuntime.convertArrayToCollectionIfNecessary(right);
            org.hamcrest.Matcher matcher = StreamSupport.stream(((Iterable)localRight).spliterator(), false).map(CoreMatchers::equalTo).collect(Collectors.collectingAndThen(Collectors.toList(), IsIterableContainingInAnyOrder::containsInAnyOrder));
            return HamcrestFacade.matches(matcher, localLeft);
        }
        if (left == null || right == null) {
            return left == null && right == null;
        }
        Pattern pattern = Pattern.compile(String.valueOf(right));
        Matcher matcher = pattern.matcher(String.valueOf(left));
        return matcher.matches();
    }

    public static <T> void verifyEach(Iterable<T> things, Function<? super T, ?> namer, @ClosureParams(value=FromString.class, options={"T", "T, int"}) @DelegatesTo(type="T", strategy=1) Closure<?> closure) {
        ArrayList<InternalItemFailure<T>> failures = new ArrayList<InternalItemFailure<T>>();
        int index = -1;
        for (T thing : things) {
            ++index;
            try {
                closure.setDelegate(thing);
                closure.setResolveStrategy(1);
                if (closure.getMaximumNumberOfParameters() == 1) {
                    GroovyRuntimeUtil.invokeClosure(closure, thing);
                    continue;
                }
                GroovyRuntimeUtil.invokeClosure(closure, thing, index);
            }
            catch (Throwable throwable) {
                failures.add(new InternalItemFailure<T>(thing, index, throwable));
            }
        }
        if (failures.size() == 1) {
            throw SpockRuntime.getAssertionFailedError(namer, (InternalItemFailure)failures.get(0));
        }
        if (!failures.isEmpty()) {
            List processedFailures = failures.stream().map(failure -> SpockRuntime.getAssertionFailedError(namer, failure)).collect(Collectors.toList());
            throw new MultipleFailuresError("", processedFailures);
        }
    }

    private static <T> SpockAssertionError getAssertionFailedError(Function<? super T, ?> namer, InternalItemFailure<T> failure) {
        SpockAssertionError error = new SpockAssertionError(String.format("Assertions failed for item[%d] %s:\n%s", ((InternalItemFailure)failure).index, namer.apply(((InternalItemFailure)failure).item), ((InternalItemFailure)failure).throwable.getMessage()));
        error.setStackTrace(((InternalItemFailure)failure).throwable.getStackTrace());
        return error;
    }

    private static boolean isVoidMethod(Object target, String method, Object ... args) {
        if (target instanceof Closure) {
            Closure closure = (Closure)target;
            return GroovyRuntimeUtil.isVoidMethod(closure.getDelegate(), method, args) || SpockRuntime.isVoidMethod(closure.getOwner(), method, args);
        }
        return GroovyRuntimeUtil.isVoidMethod(target, method, args);
    }

    public static Object[] despreadList(Object[] args, Object[] spreads, int[] positions) {
        return GroovyRuntimeUtil.despreadList(args, spreads, positions);
    }

    public static void callBlockEntered(Specification specification, int blockInfoIndex) {
        SpecificationContext context = (SpecificationContext)specification.getSpecificationContext();
        IterationInfo currentIteration = context.getCurrentIteration();
        BlockInfo blockInfo = context.getCurrentFeature().getBlocks().get(blockInfoIndex);
        context.setCurrentBlock(blockInfo);
        SpockRuntime.notifyBlockListener(currentIteration, blockListener -> blockListener.blockEntered(specification, blockInfo));
    }

    private static void notifyBlockListener(IterationInfo currentIteration, Consumer<IBlockListener> consumer) {
        List<IBlockListener> blockListeners = currentIteration.getFeature().getBlockListeners();
        if (blockListeners.isEmpty()) {
            return;
        }
        blockListeners.forEach(consumer);
    }

    public static void callBlockExited(Specification specification, int blockInfoIndex) {
        SpecificationContext context = (SpecificationContext)specification.getSpecificationContext();
        IterationInfo currentIteration = context.getCurrentIteration();
        BlockInfo blockInfo = context.getCurrentFeature().getBlocks().get(blockInfoIndex);
        SpockRuntime.notifyBlockListener(currentIteration, blockListener -> blockListener.blockExited(specification, blockInfo));
        context.setCurrentBlock(null);
    }

    private static List<Object> getValues(ValueRecorder recorder) {
        return recorder == null ? null : recorder.getValues();
    }

    private static String messageToString(Object message) {
        if (message == null) {
            return null;
        }
        return GroovyRuntimeUtil.toString(message);
    }

    private static boolean isIterableOrArray(Object o) {
        return o instanceof Iterable || ReflectionUtil.isArray(o);
    }

    private static Object convertArrayToCollectionIfNecessary(Object o) {
        if (ReflectionUtil.isArray(o)) {
            return GroovyRuntimeUtil.coerce(o, List.class);
        }
        return o;
    }

    private static final class InternalItemFailure<T> {
        private final T item;
        private final int index;
        private final Throwable throwable;

        InternalItemFailure(T item, int index, Throwable throwable) {
            this.item = item;
            this.index = index;
            this.throwable = throwable;
        }
    }

    private static class CollectionCondition {
        private final String method;
        private final Object left;
        private final Object right;

        public CollectionCondition(String method, Object left, Object right) {
            this.method = method;
            this.left = left;
            this.right = right;
        }

        void verify(ErrorCollector errorCollector, List<Object> values, String text, int line, int column, String message) {
            String description = null;
            int idxActual = values.indexOf(this.left);
            int idxExpected = values.indexOf(this.right);
            if (SpockRuntime.isIterableOrArray(this.left) && SpockRuntime.isIterableOrArray(this.right)) {
                if (SpockRuntime.MATCH_COLLECTIONS_AS_SET.equals(this.method)) {
                    Set expected;
                    Set actual = GroovyRuntimeUtil.coerce(this.left, LinkedHashSet.class);
                    if (GroovyRuntimeUtil.equals(actual, expected = (Set)GroovyRuntimeUtil.coerce(this.right, LinkedHashSet.class))) {
                        return;
                    }
                    values.set(idxActual, actual);
                    values.set(idxExpected, expected);
                } else {
                    Object localLeft = SpockRuntime.convertArrayToCollectionIfNecessary(this.left);
                    Object localRight = SpockRuntime.convertArrayToCollectionIfNecessary(this.right);
                    org.hamcrest.Matcher matcher = StreamSupport.stream(((Iterable)localRight).spliterator(), false).map(CoreMatchers::equalTo).collect(Collectors.collectingAndThen(Collectors.toList(), IsIterableContainingInAnyOrder::containsInAnyOrder));
                    if (HamcrestFacade.matches(matcher, localLeft)) {
                        return;
                    }
                    description = HamcrestFacade.getFailureDescription(matcher, this.left, message);
                }
                values.add(values.size() - 2, false);
            } else if (this.left == null || this.right == null) {
                values.set(idxActual, this.left);
                values.set(idxExpected, this.right);
                if (this.left == null && this.right == null) {
                    return;
                }
                values.set(3, false);
            } else {
                Pattern pattern = Pattern.compile(String.valueOf(this.right));
                Matcher matcher = pattern.matcher(String.valueOf(this.left));
                values.set(idxActual, this.left);
                values.set(idxExpected, this.right);
                if (SpockRuntime.MATCH_COLLECTIONS_AS_SET.equals(this.method)) {
                    if (matcher.find()) {
                        return;
                    }
                    values.set(3, matcher);
                } else {
                    if (matcher.matches()) {
                        return;
                    }
                    values.set(3, false);
                }
            }
            values.remove(0);
            Condition condition = new Condition(values, text, TextPosition.create(line, column), description, null, null);
            errorCollector.collectOrThrow(new ConditionNotSatisfiedError(condition));
        }

        static CollectionCondition parse(Object target, String method, Object[] args, boolean safe) {
            if (safe) {
                return null;
            }
            if (target == SpockRuntime.class && (SpockRuntime.MATCH_COLLECTIONS_AS_SET.equals(method) || SpockRuntime.MATCH_COLLECTIONS_IN_ANY_ORDER.equals(method))) {
                return new CollectionCondition(method, args[0], args[1]);
            }
            return null;
        }
    }

    private static class MatcherCondition {
        final Object actual;
        final Object matcher;
        final boolean shortSyntax;

        MatcherCondition(Object actual, Object matcher, boolean shortSyntax) {
            this.actual = actual;
            this.matcher = matcher;
            this.shortSyntax = shortSyntax;
        }

        void verify(ErrorCollector errorCollector, List<Object> values, String text, int line, int column, String message) {
            if (HamcrestFacade.matches(this.matcher, this.actual)) {
                return;
            }
            if (values != null) {
                CollectionUtil.setLastElement(values, this.shortSyntax ? this.actual : Boolean.valueOf(false));
                this.replaceMatcherValues(values);
            }
            String description = HamcrestFacade.getFailureDescription(this.matcher, this.actual, message);
            Condition condition = new Condition(values, text, TextPosition.create(line, column), description, null, null);
            errorCollector.collectOrThrow(new ConditionNotSatisfiedError(condition));
        }

        void replaceMatcherValues(List<Object> values) {
            boolean firstOccurrence = true;
            ListIterator<Object> iter = values.listIterator(values.size());
            while (iter.hasPrevious()) {
                Object value = iter.previous();
                if (!HamcrestFacade.isMatcher(value)) continue;
                if (firstOccurrence) {
                    iter.set(this.shortSyntax ? Boolean.valueOf(false) : ExpressionInfo.VALUE_NOT_AVAILABLE);
                    firstOccurrence = false;
                    continue;
                }
                iter.set(ExpressionInfo.VALUE_NOT_AVAILABLE);
            }
        }

        static MatcherCondition parse(Object target, String method, Object[] args, boolean safe) {
            if (safe) {
                return null;
            }
            if ("call".equals(method)) {
                if (args.length != 1 || !HamcrestFacade.isMatcher(args[0])) {
                    return null;
                }
                return new MatcherCondition(target, args[0], true);
            }
            if ("that".equals(method) || "expect".equals(method)) {
                if (target != HamcrestSupport.class) {
                    return null;
                }
                if (args.length != 2 || !HamcrestFacade.isMatcher(args[1])) {
                    return null;
                }
                return new MatcherCondition(args[0], args[1], false);
            }
            return null;
        }
    }
}

