/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.spockframework.runtime.SpockException;
import org.spockframework.util.Checks;
import org.spockframework.util.ReflectionUtil;

public interface IStore {
    public <V> V get(Object var1);

    public <V> V get(Object var1, Class<V> var2);

    default public <V> V getOrDefault(Object key, Class<V> requiredType, V defaultValue) {
        V value = this.get(key, requiredType);
        return value == null ? defaultValue : value;
    }

    default public <V> V getOrDefault(Object key, Class<V> requiredType, Supplier<V> defaultValueSupplier) {
        V value = this.get(key, requiredType);
        return value == null ? defaultValueSupplier.get() : value;
    }

    default public <V> V getOrComputeIfAbsent(Class<V> type) {
        return (V)this.getOrComputeIfAbsent(type, x$0 -> ReflectionUtil.newInstance(x$0, new Object[0]), type);
    }

    public <K, V> V getOrComputeIfAbsent(K var1, Function<K, V> var2);

    public <K, V> V getOrComputeIfAbsent(K var1, Function<K, V> var2, Class<V> var3);

    public <V> V put(Object var1, Object var2);

    public <V> V remove(Object var1);

    public <V> V remove(Object var1, Class<V> var2);

    default public IStore getRootStore() {
        IStore parent;
        IStore current = this;
        while ((parent = current.getParentStore()) != null) {
            current = parent;
        }
        return current;
    }

    public IStore getParentStore();

    public static class StoreException
    extends SpockException {
        public StoreException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class Namespace {
        private final List<Object> parts;

        public static Namespace create(Object ... parts) {
            Checks.notEmpty(parts, () -> "parts array must not be null or empty");
            Checks.containsNoNullElements(parts, () -> "individual parts must not be null: " + Arrays.toString(parts));
            return new Namespace(new ArrayList<Object>(Arrays.asList(parts)));
        }

        private Namespace(List<Object> parts) {
            this.parts = parts;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Namespace that = (Namespace)o;
            return this.parts.equals(that.parts);
        }

        public int hashCode() {
            return this.parts.hashCode();
        }

        public Namespace append(Object ... parts) {
            Checks.notEmpty(parts, () -> "parts array must not be null or empty");
            Checks.containsNoNullElements(parts, () -> "individual parts must not be null: " + Arrays.toString(parts));
            ArrayList<Object> newParts = new ArrayList<Object>(this.parts.size() + parts.length);
            newParts.addAll(this.parts);
            Collections.addAll(newParts, parts);
            return new Namespace(newParts);
        }

        public String toString() {
            return "Namespace{parts=" + this.parts + '}';
        }
    }
}

