/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.lang.reflect.Method;
import java.time.Duration;
import org.spockframework.runtime.extension.IStatelessAnnotationDrivenExtension;
import org.spockframework.runtime.extension.builtin.TimeoutConfiguration;
import org.spockframework.runtime.extension.builtin.TimeoutInterceptor;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.SpecInfo;
import spock.lang.Timeout;

public class TimeoutExtension
implements IStatelessAnnotationDrivenExtension<Timeout> {
    private final TimeoutConfiguration configuration;

    public TimeoutExtension(TimeoutConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void visitSpecAnnotation(Timeout timeout, SpecInfo spec) {
        for (FeatureInfo feature : spec.getFeatures()) {
            if (((Method)feature.getFeatureMethod().getReflection()).isAnnotationPresent(Timeout.class)) continue;
            this.visitFeatureAnnotation(timeout, feature);
        }
    }

    @Override
    public void visitFeatureAnnotation(Timeout timeout, FeatureInfo feature) {
        feature.getFeatureMethod().addInterceptor(new TimeoutInterceptor(Duration.ofNanos(timeout.unit().toNanos(timeout.value())), this.configuration));
    }

    @Override
    public void visitFixtureAnnotation(Timeout timeout, MethodInfo fixtureMethod) {
        fixtureMethod.addInterceptor(new TimeoutInterceptor(Duration.ofNanos(timeout.unit().toNanos(timeout.value())), this.configuration));
    }
}

