/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import org.spockframework.runtime.SpockException;
import org.spockframework.runtime.extension.builtin.ThreadDumpUtility;
import org.spockframework.runtime.extension.builtin.ThreadDumpUtilityType;
import org.spockframework.util.TextUtil;

public interface JavaProcessThreadDumpCollector {
    public static final JavaProcessThreadDumpCollector NO_OP = __ -> {};

    public void appendThreadDumpOfCurrentJvm(StringBuilder var1) throws IOException, InterruptedException;

    public static JavaProcessThreadDumpCollector create(ThreadDumpUtilityType utility) {
        try {
            return new FunctionalJavaProcessThreadDumpCollector(utility);
        }
        catch (Exception e) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(stream));
            System.out.printf("Thread dump capturing is not available: " + stream, new Object[0]);
            return NO_OP;
        }
    }

    public static class FunctionalJavaProcessThreadDumpCollector
    implements JavaProcessThreadDumpCollector {
        private static final String JAVA_HOME_SYS_PROP = "java.home";
        private final String utilityName;
        private final List<String> command;

        public FunctionalJavaProcessThreadDumpCollector(ThreadDumpUtility utility) {
            this.utilityName = utility.getName();
            this.command = utility.getCommand(FunctionalJavaProcessThreadDumpCollector.getJavaHome(), FunctionalJavaProcessThreadDumpCollector.currentProcessId());
        }

        @Override
        public void appendThreadDumpOfCurrentJvm(StringBuilder builder) throws IOException, InterruptedException {
            builder.append("Thread dump of current JVM (").append(this.utilityName).append("):\n");
            builder.append("------------------------------").append(TextUtil.repeatChar('-', this.utilityName.length())).append("\n");
            Process process = new ProcessBuilder(this.command).redirectErrorStream(true).start();
            this.captureProcessOutput(process, builder);
            process.waitFor();
        }

        private void captureProcessOutput(Process process, StringBuilder builder) throws IOException {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    builder.append(line).append("\n");
                }
            }
        }

        private static Path getJavaHome() {
            return Optional.ofNullable(System.getProperty(JAVA_HOME_SYS_PROP)).map(x$0 -> Paths.get(x$0, new String[0])).orElseThrow(() -> new SpockException("Could not determine java home directory, as 'java.home' system property is not set"));
        }

        private static long currentProcessId() {
            try {
                String jvmName = ManagementFactory.getRuntimeMXBean().getName();
                return Long.parseLong(jvmName.split("@")[0]);
            }
            catch (Exception e) {
                throw new SpockException("Could not determine the current process ID", e);
            }
        }
    }
}

