/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spockframework.util.ObjectUtil;

public final class VersionNumber
implements Comparable<VersionNumber> {
    public static final VersionNumber UNKNOWN = new VersionNumber(0, 0, 0, false, null);
    private static final Pattern versionPattern = Pattern.compile("(?<major>\\d+)(?:\\.(?<minor>\\d+))?+(?:\\.(?<micro>\\d+))?+(?<qualifier>[-.].+?)??(?<snapshot>-SNAPSHOT)?");
    private static final String versionTemplate = "%d.%d.%d%s";
    private final int major;
    private final int minor;
    private final int micro;
    private final boolean isSnapshot;
    private final String qualifier;
    private final int versionFields;

    public VersionNumber(int major, int minor, int micro, boolean isSnapshot, String qualifier) {
        this(major, minor, micro, isSnapshot, qualifier == null ? null : "-" + qualifier, 3);
    }

    VersionNumber(int major, int minor, int micro, boolean isSnapshot, String qualifier, int versionFields) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.isSnapshot = isSnapshot;
        this.qualifier = qualifier;
        this.versionFields = versionFields;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier == null ? null : this.qualifier.substring(1);
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    @Override
    public int compareTo(VersionNumber other) {
        if (this.major != other.major) {
            return this.major - other.major;
        }
        if (this.minor != other.minor) {
            return this.minor - other.minor;
        }
        if (this.micro != other.micro) {
            return this.micro - other.micro;
        }
        int qualComp = ObjectUtil.compare(this.getQualifier(), other.getQualifier());
        if (qualComp != 0) {
            return qualComp;
        }
        return this.isSnapshot == other.isSnapshot ? 0 : (this.isSnapshot ? -1 : 1);
    }

    public boolean equals(Object other) {
        return other instanceof VersionNumber && this.compareTo((VersionNumber)other) == 0;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.micro;
        result = 31 * result + ObjectUtil.hashCode(this.getQualifier());
        result = 31 * result + Boolean.hashCode(this.isSnapshot);
        return result;
    }

    public String toString() {
        return String.format(versionTemplate, this.major, this.minor, this.micro, (this.qualifier == null ? "" : "-" + this.getQualifier()) + (this.isSnapshot ? "-SNAPSHOT" : ""));
    }

    public String toOriginalString() {
        return this.toOriginalString(true, true);
    }

    public String toOriginalString(boolean includeQualifier, boolean includeSnapshot) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major);
        if (this.versionFields > 1) {
            sb.append('.').append(this.minor);
            if (this.versionFields > 2) {
                sb.append('.').append(this.micro);
            }
        }
        if (includeQualifier && this.qualifier != null) {
            sb.append(this.qualifier);
        }
        if (includeSnapshot && this.isSnapshot) {
            sb.append("-SNAPSHOT");
        }
        return sb.toString();
    }

    public static VersionNumber parse(String versionString) {
        if (versionString == null) {
            return UNKNOWN;
        }
        Matcher m = versionPattern.matcher(versionString);
        if (!m.matches()) {
            return UNKNOWN;
        }
        int major = Integer.parseInt(m.group("major"));
        String minorString = m.group("minor");
        int minor = minorString == null ? 0 : Integer.parseInt(minorString);
        String microString = m.group("micro");
        int micro = microString == null ? 0 : Integer.parseInt(microString);
        String qualifier = m.group("qualifier");
        boolean isSnapshot = m.group("snapshot") != null;
        int versionFields = 1;
        if (minorString != null) {
            ++versionFields;
            if (microString != null) {
                ++versionFields;
            }
        }
        return new VersionNumber(major, minor, micro, isSnapshot, qualifier, versionFields);
    }
}

