/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util.inspector;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.IOException;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.intellij.lang.annotations.Language;
import org.spockframework.compiler.AstUtil;
import org.spockframework.util.inspector.AstInspectorException;
import org.spockframework.util.inspector.Inspect;

public class AstInspector {
    private static final String EXPRESSION_MARKER_PREFIX = "inspect_";
    private CompilePhase compilePhase = CompilePhase.CONVERSION;
    private boolean throwOnNodeNotFound = true;
    private final MyClassLoader classLoader;
    private final MyVisitor visitor = new MyVisitor();
    private ModuleNode module;
    private final Map<String, AnnotatedNode> markedNodes = new HashMap<String, AnnotatedNode>();
    private final Map<String, ClassNode> classes = new HashMap<String, ClassNode>();
    private final Map<String, FieldNode> fields = new HashMap<String, FieldNode>();
    private final Map<String, PropertyNode> properties = new HashMap<String, PropertyNode>();
    private final Map<String, ConstructorNode> constructors = new HashMap<String, ConstructorNode>();
    private final Map<String, MethodNode> methods = new HashMap<String, MethodNode>();
    private final Map<String, Statement> statements = new HashMap<String, Statement>();
    private final Map<String, Expression> expressions = new HashMap<String, Expression>();

    public AstInspector() {
        this.classLoader = new MyClassLoader(AstInspector.class.getClassLoader(), null);
    }

    public AstInspector(CompilePhase phase) {
        this();
        this.setCompilePhase(phase);
    }

    public AstInspector(ClassLoader parent, CompilerConfiguration config) {
        this.classLoader = new MyClassLoader(parent, config);
    }

    public void setCompilePhase(CompilePhase phase) {
        if (phase.getPhaseNumber() < CompilePhase.CONVERSION.getPhaseNumber()) {
            throw new IllegalArgumentException("AST is only available from phase CONVERSION onwards");
        }
        this.compilePhase = phase;
    }

    public void setThrowOnNodeNotFound(boolean flag) {
        this.throwOnNodeNotFound = flag;
    }

    public void load(@Language(value="Groovy") String sourceText) throws CompilationFailedException {
        this.reset();
        try {
            this.classLoader.parseClass(sourceText);
        }
        catch (AstSuccessfullyCaptured e) {
            this.indexAstNodes();
            return;
        }
        throw new AstInspectorException("internal error");
    }

    public void load(File sourceFile) throws CompilationFailedException {
        this.reset();
        try {
            this.classLoader.parseClass(sourceFile);
        }
        catch (IOException e) {
            throw new AstInspectorException("cannot read source file", e);
        }
        catch (AstSuccessfullyCaptured e) {
            this.indexAstNodes();
            return;
        }
        throw new AstInspectorException("internal error");
    }

    public ModuleNode getModule() {
        return this.module;
    }

    public AnnotatedNode getMarkedNode(String name) {
        return this.getNode(this.markedNodes, name);
    }

    public ClassNode getClass(String name) {
        return this.getNode(this.classes, name);
    }

    public FieldNode getField(String name) {
        return this.getNode(this.fields, name);
    }

    public PropertyNode getProperty(String name) {
        return this.getNode(this.properties, name);
    }

    public ConstructorNode getConstructor(String className) {
        return this.getNode(this.constructors, className);
    }

    public MethodNode getMethod(String name) {
        return this.getNode(this.methods, name);
    }

    public List<Statement> getScriptStatements() {
        return AstInspector.getStatements(this.module.getStatementBlock());
    }

    public List<Expression> getScriptExpressions() {
        return AstInspector.getExpressions(this.getScriptStatements());
    }

    public List<Statement> getStatements(MethodNode node) {
        return AstInspector.getStatements((BlockStatement)node.getCode());
    }

    public List<Expression> getExpressions(MethodNode node) {
        return AstInspector.getExpressions(this.getStatements(node));
    }

    public List<Statement> getStatements(ClosureExpression expr) {
        return AstInspector.getStatements((BlockStatement)expr.getCode());
    }

    public List<Expression> getExpressions(ClosureExpression expr) {
        return AstInspector.getExpressions(this.getStatements(expr));
    }

    public Statement getStatement(String name) {
        return this.getNode(this.statements, name);
    }

    public Expression getExpression(String name) {
        return this.getNode(this.expressions, name);
    }

    private void indexAstNodes() {
        this.visitor.visitBlockStatement(this.module.getStatementBlock());
        for (MethodNode method : this.module.getMethods()) {
            this.visitor.visitMethod(method);
        }
        for (ClassNode clazz : this.module.getClasses()) {
            this.visitor.visitClass(clazz);
        }
    }

    private void reset() {
        this.module = null;
        this.markedNodes.clear();
        this.classes.clear();
        this.fields.clear();
        this.properties.clear();
        this.constructors.clear();
        this.methods.clear();
        this.statements.clear();
        this.expressions.clear();
    }

    private <T extends ASTNode> void addNode(Map<String, T> map, String name, T node) {
        if (!map.containsKey(name)) {
            map.put(name, node);
        }
    }

    private <T> T getNode(Map<String, T> nodes, String key) {
        T node = nodes.get(key);
        if (node == null && this.throwOnNodeNotFound) {
            throw new AstInspectorException(String.format("cannot find a node named '%s' of the requested kind", key));
        }
        return node;
    }

    private static List<Statement> getStatements(BlockStatement blockStat) {
        return blockStat == null ? Collections.emptyList() : blockStat.getStatements();
    }

    private static List<Expression> getExpressions(List<Statement> statements) {
        ArrayList<Expression> exprs = new ArrayList<Expression>();
        for (Statement stat : statements) {
            if (!(stat instanceof ExpressionStatement)) continue;
            exprs.add(((ExpressionStatement)stat).getExpression());
        }
        return exprs;
    }

    private static class AstSuccessfullyCaptured
    extends Error {
        private AstSuccessfullyCaptured() {
        }
    }

    private class MyVisitor
    extends ClassCodeVisitorSupport {
        private MyVisitor() {
        }

        public void visitAnnotations(AnnotatedNode node) {
            for (AnnotationNode an : node.getAnnotations()) {
                ClassNode cn = an.getClassNode();
                if (!cn.getNameWithoutPackage().equals(Inspect.class.getSimpleName())) continue;
                ConstantExpression name = (ConstantExpression)an.getMember("value");
                if (name == null || !(name.getValue() instanceof String)) {
                    throw new AstInspectorException("@Inspect must have a String argument");
                }
                AstInspector.this.addNode(AstInspector.this.markedNodes, (String)name.getValue(), (ASTNode)node);
                break;
            }
            super.visitAnnotations(node);
        }

        public void visitClass(ClassNode node) {
            AstInspector.this.addNode(AstInspector.this.classes, node.getNameWithoutPackage(), (ASTNode)node);
            super.visitClass(node);
        }

        public void visitField(FieldNode node) {
            AstInspector.this.addNode(AstInspector.this.fields, node.getName(), (ASTNode)node);
            super.visitField(node);
        }

        public void visitProperty(PropertyNode node) {
            AstInspector.this.addNode(AstInspector.this.properties, node.getName(), (ASTNode)node);
            super.visitProperty(node);
        }

        protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
            for (Parameter param : node.getParameters()) {
                this.visitAnnotations((AnnotatedNode)param);
                if (param.getInitialExpression() == null) continue;
                param.getInitialExpression().visit((GroovyCodeVisitor)this);
            }
            super.visitConstructorOrMethod(node, isConstructor);
        }

        public void visitConstructor(ConstructorNode node) {
            AstInspector.this.addNode(AstInspector.this.constructors, node.getDeclaringClass().getNameWithoutPackage(), (ASTNode)node);
            super.visitConstructor(node);
        }

        public void visitMethod(MethodNode node) {
            AstInspector.this.addNode(AstInspector.this.methods, node.getName(), (ASTNode)node);
            super.visitMethod(node);
        }

        public void visitStatement(Statement node) {
            if (node.getStatementLabel() != null) {
                AstInspector.this.addNode(AstInspector.this.statements, node.getStatementLabel(), (ASTNode)node);
                if (node instanceof ExpressionStatement) {
                    AstInspector.this.addNode(AstInspector.this.expressions, node.getStatementLabel(), (ASTNode)((ExpressionStatement)node).getExpression());
                }
            }
            super.visitStatement(node);
        }

        public void visitMethodCallExpression(MethodCallExpression node) {
            if (node.isImplicitThis()) {
                this.doVisitMethodCall((Expression)node);
            }
            super.visitMethodCallExpression(node);
        }

        public void visitStaticMethodCallExpression(StaticMethodCallExpression node) {
            this.doVisitMethodCall((Expression)node);
            super.visitStaticMethodCallExpression(node);
        }

        private void doVisitMethodCall(Expression node) {
            ArgumentListExpression args;
            String methodName = AstUtil.getMethodName(node);
            if (methodName != null && methodName.startsWith(AstInspector.EXPRESSION_MARKER_PREFIX) && (args = (ArgumentListExpression)AstUtil.getArguments(node)) != null && args.getExpressions().size() == 1) {
                AstInspector.this.addNode(AstInspector.this.expressions, methodName.substring(AstInspector.EXPRESSION_MARKER_PREFIX.length()), (ASTNode)args.getExpressions().get(0));
            }
        }

        protected SourceUnit getSourceUnit() {
            throw new AstInspectorException("internal error");
        }
    }

    private class MyClassLoader
    extends GroovyClassLoader {
        MyClassLoader(ClassLoader parent, CompilerConfiguration config) {
            super(parent, config);
        }

        protected CompilationUnit createCompilationUnit(CompilerConfiguration config, CodeSource source) {
            CompilationUnit unit = super.createCompilationUnit(config, source);
            unit.addPhaseOperation(new CompilationUnit.SourceUnitOperation(){

                public void call(SourceUnit source) throws CompilationFailedException {
                    AstInspector.this.module = source.getAST();
                    throw new AstSuccessfullyCaptured();
                }
            }, AstInspector.this.compilePhase.getPhaseNumber());
            return unit;
        }
    }
}

