/*
 * Decompiled with CFR 0.152.
 */
package spock.util.environment;

import org.spockframework.util.VersionNumber;

public class Jvm {
    private final String javaVersion = System.getProperty("java.version");
    private final String javaSpecVersion = System.getProperty("java.specification.version");
    private final VersionNumber javaSpecVersionNumber = VersionNumber.parse(this.javaSpecVersion);

    private Jvm() {
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getJavaSpecificationVersion() {
        return this.javaSpecVersion;
    }

    public boolean isJava8() {
        return "1.8".equals(this.javaSpecVersion);
    }

    public boolean isJava9() {
        return "9".equals(this.javaSpecVersion);
    }

    public boolean isJava10() {
        return "10".equals(this.javaSpecVersion);
    }

    public boolean isJava11() {
        return "11".equals(this.javaSpecVersion);
    }

    public boolean isJava12() {
        return "12".equals(this.javaSpecVersion);
    }

    public boolean isJava13() {
        return "13".equals(this.javaSpecVersion);
    }

    public boolean isJava14() {
        return "14".equals(this.javaSpecVersion);
    }

    public boolean isJava15() {
        return "15".equals(this.javaSpecVersion);
    }

    public boolean isJava16() {
        return "16".equals(this.javaSpecVersion);
    }

    public boolean isJava17() {
        return "17".equals(this.javaSpecVersion);
    }

    public boolean isJava18() {
        return "18".equals(this.javaSpecVersion);
    }

    public boolean isJava19() {
        return "19".equals(this.javaSpecVersion);
    }

    public boolean isJava20() {
        return "20".equals(this.javaSpecVersion);
    }

    public boolean isJava21() {
        return "21".equals(this.javaSpecVersion);
    }

    public boolean isJava22() {
        return "22".equals(this.javaSpecVersion);
    }

    public boolean isJava23() {
        return "23".equals(this.javaSpecVersion);
    }

    public boolean isJava24() {
        return "24".equals(this.javaSpecVersion);
    }

    public boolean isJava25() {
        return "25".equals(this.javaSpecVersion);
    }

    public boolean isJava26() {
        return "26".equals(this.javaSpecVersion);
    }

    public boolean isJava27() {
        return "27".equals(this.javaSpecVersion);
    }

    public boolean isJava28() {
        return "28".equals(this.javaSpecVersion);
    }

    public boolean isJava29() {
        return "29".equals(this.javaSpecVersion);
    }

    public boolean isJavaVersion(int majorJavaVersion) {
        if (majorJavaVersion == 8) {
            return this.isJava8();
        }
        return this.javaSpecVersionNumber.getMajor() == majorJavaVersion;
    }

    public boolean isJava8Compatible() {
        return this.javaSpecVersionNumber.getMajor() > 1 || this.javaSpecVersionNumber.getMinor() >= 8;
    }

    public boolean isJava9Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 9;
    }

    public boolean isJava10Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 10;
    }

    public boolean isJava11Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 11;
    }

    public boolean isJava12Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 12;
    }

    public boolean isJava13Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 13;
    }

    public boolean isJava14Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 14;
    }

    public boolean isJava15Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 15;
    }

    public boolean isJava16Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 16;
    }

    public boolean isJava17Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 17;
    }

    public boolean isJava18Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 18;
    }

    public boolean isJava19Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 19;
    }

    public boolean isJava20Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 20;
    }

    public boolean isJava21Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 21;
    }

    public boolean isJava22Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 22;
    }

    public boolean isJava23Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 23;
    }

    public boolean isJava24Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 24;
    }

    public boolean isJava25Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 25;
    }

    public boolean isJava26Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 26;
    }

    public boolean isJava27Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 27;
    }

    public boolean isJava28Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 28;
    }

    public boolean isJava29Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 29;
    }

    public boolean isJavaVersionCompatible(int majorJavaVersion) {
        if (majorJavaVersion == 8) {
            return this.isJava8Compatible();
        }
        return this.javaSpecVersionNumber.getMajor() >= majorJavaVersion;
    }

    public static Jvm getCurrent() {
        return new Jvm();
    }
}

