/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.junit4;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.opentest4j.MultipleFailuresError;
import org.opentest4j.TestAbortedException;
import org.spockframework.runtime.extension.ExtensionException;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.FieldInfo;

public abstract class AbstractRuleInterceptor
implements IMethodInterceptor {
    protected final List<FieldInfo> ruleFields;

    public AbstractRuleInterceptor(List<FieldInfo> ruleFields) {
        ArrayList<FieldInfo> reversedFields = new ArrayList<FieldInfo>(ruleFields);
        Collections.reverse(reversedFields);
        this.ruleFields = reversedFields;
    }

    protected Statement createBaseStatement(final IMethodInvocation invocation) {
        return new Statement(){

            public void evaluate() throws Throwable {
                invocation.proceed();
            }
        };
    }

    protected Object getRuleInstance(FieldInfo field, Object fieldTarget) {
        Object rule = field.readValue(fieldTarget);
        if (rule == null) {
            try {
                rule = field.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                field.writeValue(fieldTarget, rule);
            }
            catch (Exception e) {
                throw new ExtensionException("Auto-instantiating @Rule field '%s' failed. You may have to instantiate it manually.", (Throwable)e).withArgs(new Object[]{field.getName()});
            }
        }
        return rule;
    }

    protected void evaluateStatement(Statement statement) throws Throwable {
        try {
            statement.evaluate();
        }
        catch (AssumptionViolatedException assumption) {
            throw new TestAbortedException(assumption.getMessage(), (Throwable)assumption);
        }
        catch (MultipleFailureException mfe) {
            throw new MultipleFailuresError("There were multiple errors", mfe.getFailures());
        }
    }
}

