/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring.mock;

import java.util.LinkedHashSet;
import java.util.Set;
import org.spockframework.spring.mock.Definition;
import org.spockframework.spring.mock.SpockMockPostprocessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;

class SpockContextCustomizer
implements ContextCustomizer {
    private final Set<Definition> definitions;

    SpockContextCustomizer(Set<? extends Definition> definitions) {
        this.definitions = new LinkedHashSet<Definition>(definitions);
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedContextConfiguration) {
        if (context instanceof BeanDefinitionRegistry) {
            SpockMockPostprocessor.register((BeanDefinitionRegistry)context, this.definitions);
        }
    }

    public int hashCode() {
        return this.definitions.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SpockContextCustomizer other = (SpockContextCustomizer)obj;
        return this.definitions.equals(other.definitions);
    }
}

