/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.tool;

import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.springaicommunity.mcp.annotation.McpMeta;
import org.springaicommunity.mcp.annotation.McpProgressToken;
import org.springaicommunity.mcp.method.tool.ReturnMode;
import org.springaicommunity.mcp.method.tool.utils.JsonParser;

public abstract class AbstractMcpToolMethodCallback<T> {
    protected final Method toolMethod;
    protected final Object toolObject;
    protected final ReturnMode returnMode;

    protected AbstractMcpToolMethodCallback(ReturnMode returnMode, Method toolMethod, Object toolObject) {
        this.toolMethod = toolMethod;
        this.toolObject = toolObject;
        this.returnMode = returnMode;
    }

    protected Object callMethod(Object[] methodArguments) {
        Object result;
        this.toolMethod.setAccessible(true);
        try {
            result = this.toolMethod.invoke(this.toolObject, methodArguments);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Failed to access tool method", ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Error invoking method: " + this.toolMethod.getName(), ex.getCause());
        }
        return result;
    }

    protected Object[] buildMethodArguments(T exchangeOrContext, Map<String, Object> toolInputArguments, McpSchema.CallToolRequest request) {
        return Stream.of(this.toolMethod.getParameters()).map(parameter -> {
            if (parameter.isAnnotationPresent(McpProgressToken.class)) {
                return request != null ? request.progressToken() : null;
            }
            if (McpMeta.class.isAssignableFrom(parameter.getType())) {
                return request != null ? new McpMeta(request.meta()) : new McpMeta(null);
            }
            if (McpSchema.CallToolRequest.class.isAssignableFrom(parameter.getType())) {
                return request;
            }
            if (this.isExchangeOrContextType(parameter.getType())) {
                return exchangeOrContext;
            }
            Object rawArgument = toolInputArguments.get(parameter.getName());
            return this.buildTypedArgument(rawArgument, parameter.getParameterizedType());
        }).toArray();
    }

    protected Object buildTypedArgument(Object value, Type type) {
        if (value == null) {
            return null;
        }
        if (type instanceof Class) {
            return JsonParser.toTypedObject(value, (Class)type);
        }
        String json = JsonParser.toJson(value);
        return JsonParser.fromJson(json, type);
    }

    protected McpSchema.CallToolResult convertValueToCallToolResult(Object result) {
        if (result instanceof McpSchema.CallToolResult) {
            return (McpSchema.CallToolResult)result;
        }
        Type returnType = this.toolMethod.getGenericReturnType();
        if (this.returnMode == ReturnMode.VOID || returnType == Void.TYPE || returnType == Void.TYPE) {
            return McpSchema.CallToolResult.builder().addTextContent(JsonParser.toJson("Done")).build();
        }
        if (this.returnMode == ReturnMode.STRUCTURED) {
            String jsonOutput = JsonParser.toJson(result);
            Object structuredOutput = JsonParser.fromJson(jsonOutput, Object.class);
            return McpSchema.CallToolResult.builder().structuredContent(structuredOutput).build();
        }
        if (result == null) {
            return McpSchema.CallToolResult.builder().addTextContent("null").build();
        }
        if (result instanceof String) {
            return McpSchema.CallToolResult.builder().addTextContent((String)result).build();
        }
        return McpSchema.CallToolResult.builder().addTextContent(JsonParser.toJson(result)).build();
    }

    protected String createErrorMessage(Throwable e) {
        return "Error invoking method: %s".formatted(e.getMessage());
    }

    protected abstract boolean isExchangeOrContextType(Class<?> var1);

    protected Throwable findCauseUsingPlainJava(Throwable throwable) {
        Throwable rootCause;
        Objects.requireNonNull(throwable);
        for (rootCause = throwable; rootCause.getCause() != null && rootCause.getCause() != rootCause; rootCause = rootCause.getCause()) {
        }
        return rootCause;
    }
}

