/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.logging;

import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import org.springaicommunity.mcp.method.logging.AbstractMcpLoggingMethodCallback;

public final class SyncMcpLoggingMethodCallback
extends AbstractMcpLoggingMethodCallback
implements Consumer<McpSchema.LoggingMessageNotification> {
    private SyncMcpLoggingMethodCallback(Builder builder) {
        super(builder.method, builder.bean);
    }

    @Override
    public void accept(McpSchema.LoggingMessageNotification notification) {
        if (notification == null) {
            throw new IllegalArgumentException("Notification must not be null");
        }
        try {
            Object[] args = this.buildArgs(this.method, null, notification);
            this.method.setAccessible(true);
            this.method.invoke(this.bean, args);
        }
        catch (Exception e) {
            throw new AbstractMcpLoggingMethodCallback.McpLoggingConsumerMethodException("Error invoking logging consumer method: " + this.method.getName(), e);
        }
    }

    @Override
    protected void validateReturnType(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType != Void.TYPE) {
            throw new IllegalArgumentException("Method must have void return type: " + method.getName() + " in " + method.getDeclaringClass().getName() + " returns " + returnType.getName());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractMcpLoggingMethodCallback.AbstractBuilder<Builder, SyncMcpLoggingMethodCallback> {
        @Override
        public SyncMcpLoggingMethodCallback build() {
            this.validate();
            return new SyncMcpLoggingMethodCallback(this);
        }
    }
}

