/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.configuration;

import java.util.List;
import java.util.Set;
import org.springdoc.core.conditions.SpecPropertiesCondition;
import org.springdoc.core.configuration.SpringDocConfiguration;
import org.springdoc.core.customizers.SpecPropertiesCustomizer;
import org.springdoc.core.models.GroupedOpenApi;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Lazy(value=false)
@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={SpringDocConfiguration.class})
@Conditional(value={SpecPropertiesCondition.class})
public class SpringDocSpecPropertiesConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    SpecPropertiesCustomizer specificationStringPropertiesCustomizer(SpringDocConfigProperties springDocConfigProperties) {
        return new SpecPropertiesCustomizer(springDocConfigProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    static SpecificationStringPropertiesCustomizerBeanPostProcessor specificationStringPropertiesCustomizerBeanPostProcessor(SpringDocConfigProperties springDocConfigProperties) {
        return new SpecificationStringPropertiesCustomizerBeanPostProcessor(springDocConfigProperties);
    }

    public static class SpecificationStringPropertiesCustomizerBeanPostProcessor
    implements BeanPostProcessor {
        private final SpringDocConfigProperties springDocConfigProperties;

        public SpecificationStringPropertiesCustomizerBeanPostProcessor(SpringDocConfigProperties springDocConfigProperties) {
            this.springDocConfigProperties = springDocConfigProperties;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (bean instanceof GroupedOpenApi) {
                GroupedOpenApi groupedOpenApi = (GroupedOpenApi)bean;
                Set<SpringDocConfigProperties.GroupConfig> groupConfigs = this.springDocConfigProperties.getGroupConfigs();
                for (SpringDocConfigProperties.GroupConfig groupConfig : groupConfigs) {
                    if (!groupConfig.getGroup().equals(groupedOpenApi.getGroup())) continue;
                    groupedOpenApi.addAllOpenApiCustomizer(List.of(new SpecPropertiesCustomizer(groupConfig.getOpenApi())));
                }
            }
            return bean;
        }
    }
}

