/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.anthropic;

public final class Citation {
    private final LocationType type;
    private final String citedText;
    private final int documentIndex;
    private final String documentTitle;
    private Integer startCharIndex;
    private Integer endCharIndex;
    private Integer startPageNumber;
    private Integer endPageNumber;
    private Integer startBlockIndex;
    private Integer endBlockIndex;

    private Citation(LocationType type, String citedText, int documentIndex, String documentTitle) {
        this.type = type;
        this.citedText = citedText;
        this.documentIndex = documentIndex;
        this.documentTitle = documentTitle;
    }

    public static Citation ofCharLocation(String citedText, int documentIndex, String documentTitle, int startCharIndex, int endCharIndex) {
        Citation citation = new Citation(LocationType.CHAR_LOCATION, citedText, documentIndex, documentTitle);
        citation.startCharIndex = startCharIndex;
        citation.endCharIndex = endCharIndex;
        return citation;
    }

    public static Citation ofPageLocation(String citedText, int documentIndex, String documentTitle, int startPageNumber, int endPageNumber) {
        Citation citation = new Citation(LocationType.PAGE_LOCATION, citedText, documentIndex, documentTitle);
        citation.startPageNumber = startPageNumber;
        citation.endPageNumber = endPageNumber;
        return citation;
    }

    public static Citation ofContentBlockLocation(String citedText, int documentIndex, String documentTitle, int startBlockIndex, int endBlockIndex) {
        Citation citation = new Citation(LocationType.CONTENT_BLOCK_LOCATION, citedText, documentIndex, documentTitle);
        citation.startBlockIndex = startBlockIndex;
        citation.endBlockIndex = endBlockIndex;
        return citation;
    }

    public LocationType getType() {
        return this.type;
    }

    public String getCitedText() {
        return this.citedText;
    }

    public int getDocumentIndex() {
        return this.documentIndex;
    }

    public String getDocumentTitle() {
        return this.documentTitle;
    }

    public Integer getStartCharIndex() {
        return this.startCharIndex;
    }

    public Integer getEndCharIndex() {
        return this.endCharIndex;
    }

    public Integer getStartPageNumber() {
        return this.startPageNumber;
    }

    public Integer getEndPageNumber() {
        return this.endPageNumber;
    }

    public Integer getStartBlockIndex() {
        return this.startBlockIndex;
    }

    public Integer getEndBlockIndex() {
        return this.endBlockIndex;
    }

    public String getLocationDescription() {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case LocationType.CHAR_LOCATION -> String.format("Characters %d-%d", this.startCharIndex, this.endCharIndex);
            case LocationType.PAGE_LOCATION -> {
                if (this.startPageNumber.equals(this.endPageNumber - 1)) {
                    yield String.format("Page %d", this.startPageNumber);
                }
                yield String.format("Pages %d-%d", this.startPageNumber, this.endPageNumber - 1);
            }
            case LocationType.CONTENT_BLOCK_LOCATION -> this.startBlockIndex.equals(this.endBlockIndex - 1) ? String.format("Block %d", this.startBlockIndex) : String.format("Blocks %d-%d", this.startBlockIndex, this.endBlockIndex - 1);
        };
    }

    public String toString() {
        return String.format("Citation{type=%s, documentIndex=%d, documentTitle='%s', location='%s', citedText='%s'}", new Object[]{this.type, this.documentIndex, this.documentTitle, this.getLocationDescription(), this.citedText != null && this.citedText.length() > 50 ? this.citedText.substring(0, 50) + "..." : this.citedText});
    }

    public static enum LocationType {
        CHAR_LOCATION,
        PAGE_LOCATION,
        CONTENT_BLOCK_LOCATION;

    }
}

