/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.client.common.autoconfigure.annotations;

import java.util.List;
import org.springaicommunity.mcp.annotation.McpElicitation;
import org.springaicommunity.mcp.annotation.McpLogging;
import org.springaicommunity.mcp.annotation.McpProgress;
import org.springaicommunity.mcp.annotation.McpSampling;
import org.springaicommunity.mcp.method.elicitation.AsyncElicitationSpecification;
import org.springaicommunity.mcp.method.elicitation.SyncElicitationSpecification;
import org.springaicommunity.mcp.method.logging.AsyncLoggingSpecification;
import org.springaicommunity.mcp.method.logging.SyncLoggingSpecification;
import org.springaicommunity.mcp.method.progress.AsyncProgressSpecification;
import org.springaicommunity.mcp.method.progress.SyncProgressSpecification;
import org.springaicommunity.mcp.method.sampling.AsyncSamplingSpecification;
import org.springaicommunity.mcp.method.sampling.SyncSamplingSpecification;
import org.springframework.ai.mcp.annotation.spring.AsyncMcpAnnotationProviders;
import org.springframework.ai.mcp.annotation.spring.SyncMcpAnnotationProviders;
import org.springframework.ai.mcp.client.common.autoconfigure.annotations.McpClientAnnotationScannerAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration(after={McpClientAnnotationScannerAutoConfiguration.class})
@ConditionalOnClass(value={McpLogging.class})
@ConditionalOnProperty(prefix="spring.ai.mcp.client.annotation-scanner", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class McpClientSpecificationFactoryAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="ASYNC")
    static class AsyncClientSpecificationConfiguration {
        AsyncClientSpecificationConfiguration() {
        }

        @Bean
        List<AsyncLoggingSpecification> loggingSpecs(McpClientAnnotationScannerAutoConfiguration.ClientMcpAnnotatedBeans beanRegistry) {
            return AsyncMcpAnnotationProviders.loggingSpecifications((List)beanRegistry.getAllAnnotatedBeans());
        }

        @Bean
        List<AsyncSamplingSpecification> samplingSpecs(McpClientAnnotationScannerAutoConfiguration.ClientMcpAnnotatedBeans beanRegistry) {
            return AsyncMcpAnnotationProviders.samplingSpecifications((List)beanRegistry.getAllAnnotatedBeans());
        }

        @Bean
        List<AsyncElicitationSpecification> elicitationSpecs(McpClientAnnotationScannerAutoConfiguration.ClientMcpAnnotatedBeans beanRegistry) {
            return AsyncMcpAnnotationProviders.elicitationSpecifications((List)beanRegistry.getAllAnnotatedBeans());
        }

        @Bean
        List<AsyncProgressSpecification> progressSpecs(McpClientAnnotationScannerAutoConfiguration.ClientMcpAnnotatedBeans beanRegistry) {
            return AsyncMcpAnnotationProviders.progressSpecifications((List)beanRegistry.getAllAnnotatedBeans());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    static class SyncClientSpecificationConfiguration {
        SyncClientSpecificationConfiguration() {
        }

        @Bean
        List<SyncLoggingSpecification> loggingSpecs(McpClientAnnotationScannerAutoConfiguration.ClientMcpAnnotatedBeans beansWithMcpMethodAnnotations) {
            return SyncMcpAnnotationProviders.loggingSpecifications((List)beansWithMcpMethodAnnotations.getBeansByAnnotation(McpLogging.class));
        }

        @Bean
        List<SyncSamplingSpecification> samplingSpecs(McpClientAnnotationScannerAutoConfiguration.ClientMcpAnnotatedBeans beansWithMcpMethodAnnotations) {
            return SyncMcpAnnotationProviders.samplingSpecifications((List)beansWithMcpMethodAnnotations.getBeansByAnnotation(McpSampling.class));
        }

        @Bean
        List<SyncElicitationSpecification> elicitationSpecs(McpClientAnnotationScannerAutoConfiguration.ClientMcpAnnotatedBeans beansWithMcpMethodAnnotations) {
            return SyncMcpAnnotationProviders.elicitationSpecifications((List)beansWithMcpMethodAnnotations.getBeansByAnnotation(McpElicitation.class));
        }

        @Bean
        List<SyncProgressSpecification> progressSpecs(McpClientAnnotationScannerAutoConfiguration.ClientMcpAnnotatedBeans beansWithMcpMethodAnnotations) {
            return SyncMcpAnnotationProviders.progressSpecifications((List)beansWithMcpMethodAnnotations.getBeansByAnnotation(McpProgress.class));
        }
    }
}

