/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.client.webflux.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.client.transport.WebClientStreamableHttpTransport;
import io.modelcontextprotocol.spec.McpClientTransport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.ai.mcp.client.common.autoconfigure.NamedClientMcpTransport;
import org.springframework.ai.mcp.client.common.autoconfigure.properties.McpClientCommonProperties;
import org.springframework.ai.mcp.client.common.autoconfigure.properties.McpStreamableHttpClientProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.reactive.function.client.WebClient;

@AutoConfiguration
@ConditionalOnClass(value={WebClientStreamableHttpTransport.class, WebClient.class})
@EnableConfigurationProperties(value={McpStreamableHttpClientProperties.class, McpClientCommonProperties.class})
@ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class StreamableHttpWebFluxTransportAutoConfiguration {
    @Bean
    public List<NamedClientMcpTransport> streamableHttpWebFluxClientTransports(McpStreamableHttpClientProperties streamableProperties, ObjectProvider<WebClient.Builder> webClientBuilderProvider, ObjectProvider<ObjectMapper> objectMapperProvider) {
        ArrayList<NamedClientMcpTransport> streamableHttpTransports = new ArrayList<NamedClientMcpTransport>();
        WebClient.Builder webClientBuilderTemplate = (WebClient.Builder)webClientBuilderProvider.getIfAvailable(WebClient::builder);
        ObjectMapper objectMapper = (ObjectMapper)objectMapperProvider.getIfAvailable(ObjectMapper::new);
        for (Map.Entry serverParameters : streamableProperties.getConnections().entrySet()) {
            WebClient.Builder webClientBuilder = webClientBuilderTemplate.clone().baseUrl(((McpStreamableHttpClientProperties.ConnectionParameters)serverParameters.getValue()).url());
            String streamableHttpEndpoint = ((McpStreamableHttpClientProperties.ConnectionParameters)serverParameters.getValue()).endpoint() != null ? ((McpStreamableHttpClientProperties.ConnectionParameters)serverParameters.getValue()).endpoint() : "/mcp";
            WebClientStreamableHttpTransport transport = WebClientStreamableHttpTransport.builder((WebClient.Builder)webClientBuilder).endpoint(streamableHttpEndpoint).objectMapper(objectMapper).build();
            streamableHttpTransports.add(new NamedClientMcpTransport((String)serverParameters.getKey(), (McpClientTransport)transport));
        }
        return streamableHttpTransports;
    }
}

