/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.google.genai.cache;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.Content;
import com.google.genai.types.Part;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;

public final class CachedContentRequest {
    @JsonProperty(value="model")
    private final String model;
    @JsonProperty(value="display_name")
    private final String displayName;
    @JsonProperty(value="contents")
    private final List<Content> contents;
    @JsonProperty(value="system_instruction")
    private final Content systemInstruction;
    @JsonProperty(value="ttl")
    private final Duration ttl;
    @JsonProperty(value="expire_time")
    private final Instant expireTime;

    private CachedContentRequest(Builder builder) {
        Assert.hasText((String)builder.model, (String)"Model must not be empty");
        Assert.isTrue((builder.contents != null && !builder.contents.isEmpty() ? 1 : 0) != 0, (String)"Contents must not be empty");
        Assert.isTrue((builder.ttl != null || builder.expireTime != null ? 1 : 0) != 0, (String)"Either TTL or expire time must be set");
        this.model = builder.model;
        this.displayName = builder.displayName;
        this.contents = new ArrayList<Content>(builder.contents);
        this.systemInstruction = builder.systemInstruction;
        this.ttl = builder.ttl;
        this.expireTime = builder.expireTime;
    }

    public String getModel() {
        return this.model;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<Content> getContents() {
        return this.contents;
    }

    public Content getSystemInstruction() {
        return this.systemInstruction;
    }

    public Duration getTtl() {
        return this.ttl;
    }

    public Instant getExpireTime() {
        return this.expireTime;
    }

    public String toString() {
        return "CachedContentRequest{model='" + this.model + "', displayName='" + this.displayName + "', contentsSize=" + (this.contents != null ? this.contents.size() : 0) + ", ttl=" + String.valueOf(this.ttl) + ", expireTime=" + String.valueOf(this.expireTime) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String model;
        private String displayName;
        private List<Content> contents = new ArrayList<Content>();
        private Content systemInstruction;
        private Duration ttl;
        private Instant expireTime;

        private Builder() {
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder contents(List<Content> contents) {
            this.contents = contents != null ? new ArrayList<Content>(contents) : new ArrayList();
            return this;
        }

        public Builder addContent(Content content) {
            if (content != null) {
                this.contents.add(content);
            }
            return this;
        }

        public Builder addTextContent(String text) {
            if (text != null) {
                this.contents.add(Content.builder().parts(new Part[]{Part.builder().text(text).build()}).build());
            }
            return this;
        }

        public Builder systemInstruction(Content systemInstruction) {
            this.systemInstruction = systemInstruction;
            return this;
        }

        public Builder systemInstruction(String instruction) {
            if (instruction != null) {
                this.systemInstruction = Content.builder().parts(new Part[]{Part.builder().text(instruction).build()}).build();
            }
            return this;
        }

        public Builder ttl(Duration ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder expireTime(Instant expireTime) {
            this.expireTime = expireTime;
            return this;
        }

        public CachedContentRequest build() {
            return new CachedContentRequest(this);
        }
    }
}

