/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.converter.CompositeResponseTextCleaner;
import org.springframework.ai.converter.MarkdownCodeBlockCleaner;
import org.springframework.ai.converter.ResponseTextCleaner;
import org.springframework.ai.converter.StructuredOutputConverter;
import org.springframework.ai.converter.ThinkingTagCleaner;
import org.springframework.ai.converter.WhitespaceCleaner;
import org.springframework.ai.model.KotlinModule;
import org.springframework.ai.util.JacksonUtils;
import org.springframework.ai.util.LoggingMarkers;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.lang.NonNull;

public class BeanOutputConverter<T>
implements StructuredOutputConverter<T> {
    private final Logger logger = LoggerFactory.getLogger(BeanOutputConverter.class);
    private final Type type;
    private final ObjectMapper objectMapper;
    private String jsonSchema;
    private final ResponseTextCleaner textCleaner;

    public BeanOutputConverter(Class<T> clazz) {
        this(clazz, null, null);
    }

    public BeanOutputConverter(Class<T> clazz, ObjectMapper objectMapper) {
        this(clazz, objectMapper, null);
    }

    public BeanOutputConverter(Class<T> clazz, ObjectMapper objectMapper, ResponseTextCleaner textCleaner) {
        this(ParameterizedTypeReference.forType(clazz), objectMapper, textCleaner);
    }

    public BeanOutputConverter(ParameterizedTypeReference<T> typeRef) {
        this(typeRef, null, null);
    }

    public BeanOutputConverter(ParameterizedTypeReference<T> typeRef, ObjectMapper objectMapper) {
        this(typeRef, objectMapper, null);
    }

    public BeanOutputConverter(ParameterizedTypeReference<T> typeRef, ObjectMapper objectMapper, ResponseTextCleaner textCleaner) {
        this(typeRef.getType(), objectMapper, textCleaner);
    }

    private BeanOutputConverter(Type type, ObjectMapper objectMapper, ResponseTextCleaner textCleaner) {
        Objects.requireNonNull(type, "Type cannot be null;");
        this.type = type;
        this.objectMapper = objectMapper != null ? objectMapper : this.getObjectMapper();
        this.textCleaner = textCleaner != null ? textCleaner : BeanOutputConverter.createDefaultTextCleaner();
        this.generateSchema();
    }

    private static ResponseTextCleaner createDefaultTextCleaner() {
        return CompositeResponseTextCleaner.builder().addCleaner(new WhitespaceCleaner()).addCleaner(new ThinkingTagCleaner()).addCleaner(new MarkdownCodeBlockCleaner()).addCleaner(new WhitespaceCleaner()).build();
    }

    private void generateSchema() {
        JacksonModule jacksonModule = new JacksonModule(new JacksonOption[]{JacksonOption.RESPECT_JSONPROPERTY_REQUIRED, JacksonOption.RESPECT_JSONPROPERTY_ORDER});
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON).with((Module)jacksonModule).with(Option.FORBIDDEN_ADDITIONAL_PROPERTIES_BY_DEFAULT, new Option[0]);
        configBuilder.forFields().withRequiredCheck(f -> true);
        if (KotlinDetector.isKotlinReflectPresent()) {
            configBuilder.with((Module)new KotlinModule());
        }
        SchemaGeneratorConfig config = configBuilder.build();
        SchemaGenerator generator = new SchemaGenerator(config);
        ObjectNode jsonNode = generator.generateSchema(this.type, new Type[0]);
        ObjectWriter objectWriter = this.objectMapper.writer((PrettyPrinter)new DefaultPrettyPrinter().withObjectIndenter((DefaultPrettyPrinter.Indenter)new DefaultIndenter().withLinefeed(System.lineSeparator())));
        try {
            this.jsonSchema = objectWriter.writeValueAsString((Object)jsonNode);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Could not pretty print json schema for jsonNode: {}", (Object)jsonNode);
            throw new RuntimeException("Could not pretty print json schema for " + String.valueOf(this.type), e);
        }
    }

    public T convert(@NonNull String text) {
        try {
            text = this.textCleaner.clean(text);
            return (T)this.objectMapper.readValue(text, this.objectMapper.constructType(this.type));
        }
        catch (JsonProcessingException e) {
            this.logger.error(LoggingMarkers.SENSITIVE_DATA_MARKER, "Could not parse the given text to the desired target type: \"{}\" into {}", (Object)text, (Object)this.type);
            throw new RuntimeException(e);
        }
    }

    protected ObjectMapper getObjectMapper() {
        return ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModules((Iterable)JacksonUtils.instantiateAvailableModules())).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).build();
    }

    @Override
    public String getFormat() {
        String template = "Your response should be in JSON format.\nDo not include any explanations, only provide a RFC8259 compliant JSON response following this format without deviation.\nDo not include markdown code blocks in your response.\nRemove the ```json markdown from the output.\nHere is the JSON Schema instance your output must adhere to:\n```%s```\n";
        return String.format(template, this.jsonSchema);
    }

    public String getJsonSchema() {
        return this.jsonSchema;
    }

    public Map<String, Object> getJsonSchemaMap() {
        try {
            return (Map)this.objectMapper.readValue(this.jsonSchema, Map.class);
        }
        catch (JsonProcessingException ex) {
            this.logger.error("Could not parse the JSON Schema to a Map object", (Throwable)ex);
            throw new IllegalStateException(ex);
        }
    }
}

