/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.ClassMapper;
import org.springframework.amqp.support.converter.JavaTypeMapper;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJavaTypeMapper
implements JavaTypeMapper,
ClassMapper,
InitializingBean {
    public static final String DEFAULT_CLASSID_FIELD_NAME = "__TypeId__";
    public static final String DEFAULT_CONTENT_CLASSID_FIELD_NAME = "__ContentTypeId__";
    public static final String DEFAULT_KEY_CLASSID_FIELD_NAME = "__KeyTypeId__";
    private Map<String, Class<?>> idClassMapping = new HashMap();
    private Map<Class<?>, String> classIdMapping = new HashMap();

    public String getClassIdFieldName() {
        return DEFAULT_CLASSID_FIELD_NAME;
    }

    public String getContentClassIdFieldName() {
        return DEFAULT_CONTENT_CLASSID_FIELD_NAME;
    }

    public String getKeyClassIdFieldName() {
        return DEFAULT_KEY_CLASSID_FIELD_NAME;
    }

    @Override
    public JavaType toJavaType(MessageProperties properties) {
        JavaType classType = this.getClassIdType(this.retrieveHeader(properties, this.getClassIdFieldName()));
        if (!classType.isContainerType()) {
            return classType;
        }
        JavaType contentClassType = this.getClassIdType(this.retrieveHeader(properties, this.getContentClassIdFieldName()));
        if (classType.getKeyType() == null) {
            return TypeFactory.collectionType((Class)classType.getRawClass(), (JavaType)contentClassType);
        }
        JavaType keyClassType = this.getClassIdType(this.retrieveHeader(properties, this.getKeyClassIdFieldName()));
        JavaType mapType = TypeFactory.mapType((Class)classType.getRawClass(), (JavaType)keyClassType, (JavaType)contentClassType);
        return mapType;
    }

    private JavaType getClassIdType(String classId) {
        if (this.idClassMapping.containsKey(classId)) {
            return TypeFactory.type((Type)this.idClassMapping.get(classId));
        }
        try {
            return TypeFactory.type((Type)ClassUtils.forName((String)classId, (ClassLoader)this.getClass().getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new MessageConversionException("failed to resolve class name. Class not found [" + classId + "]", e);
        }
        catch (LinkageError e) {
            throw new MessageConversionException("failed to resolve class name. Linkage error [" + classId + "]", e);
        }
    }

    private String retrieveHeader(MessageProperties properties, String headerName) {
        Map<String, Object> headers = properties.getHeaders();
        Object classIdFieldNameValue = headers.get(headerName);
        String classId = null;
        if (classIdFieldNameValue != null) {
            classId = classIdFieldNameValue.toString();
        }
        if (classId == null) {
            throw new MessageConversionException("failed to convert Message content. Could not resolve " + headerName + " in header");
        }
        return classId;
    }

    public void setIdClassMapping(Map<String, Class<?>> idClassMapping) {
        this.idClassMapping = idClassMapping;
    }

    @Override
    public void fromJavaType(JavaType javaType, MessageProperties properties) {
        this.addHeader(properties, this.getClassIdFieldName(), javaType.getRawClass());
        if (javaType.isContainerType()) {
            this.addHeader(properties, this.getContentClassIdFieldName(), javaType.getContentType().getRawClass());
        }
        if (javaType.getKeyType() != null) {
            this.addHeader(properties, this.getKeyClassIdFieldName(), javaType.getKeyType().getRawClass());
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.validateIdTypeMapping();
    }

    private void addHeader(MessageProperties properties, String headerName, Class<?> clazz) {
        if (this.classIdMapping.containsKey(clazz)) {
            properties.getHeaders().put(headerName, this.classIdMapping.get(clazz));
        } else {
            properties.getHeaders().put(headerName, clazz.getName());
        }
    }

    private void validateIdTypeMapping() {
        HashMap finalIdClassMapping = new HashMap();
        for (Map.Entry<String, Class<?>> entry : this.idClassMapping.entrySet()) {
            String id = entry.getKey();
            Class<?> clazz = entry.getValue();
            finalIdClassMapping.put(id, clazz);
            this.classIdMapping.put(clazz, id);
        }
        this.idClassMapping = finalIdClassMapping;
    }

    @Override
    public void fromClass(Class<?> clazz, MessageProperties properties) {
        this.fromJavaType(TypeFactory.type(clazz), properties);
    }

    @Override
    public Class<?> toClass(MessageProperties properties) {
        return this.toJavaType(properties).getRawClass();
    }
}

