/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.AbstractMessageConverter;
import org.springframework.amqp.support.converter.ClassMapper;
import org.springframework.amqp.support.converter.DefaultJavaTypeMapper;
import org.springframework.amqp.support.converter.JavaTypeMapper;
import org.springframework.amqp.support.converter.MessageConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonMessageConverter
extends AbstractMessageConverter {
    private static Log log = LogFactory.getLog(JsonMessageConverter.class);
    public static final String DEFAULT_CHARSET = "UTF-8";
    private volatile String defaultCharset = "UTF-8";
    private ObjectMapper jsonObjectMapper = new ObjectMapper();
    private JavaTypeMapper javaTypeMapper = new DefaultJavaTypeMapper();
    private ClassMapper classMapper = null;

    public ClassMapper getClassMapper() {
        return this.classMapper;
    }

    public void setClassMapper(ClassMapper classMapper) {
        this.classMapper = classMapper;
    }

    public JsonMessageConverter() {
        this.initializeJsonObjectMapper();
    }

    public void setDefaultCharset(String defaultCharset) {
        this.defaultCharset = defaultCharset != null ? defaultCharset : DEFAULT_CHARSET;
    }

    public JavaTypeMapper getJavaTypeMapper() {
        return this.javaTypeMapper;
    }

    public void setJavaTypeMapper(JavaTypeMapper javaTypeMapper) {
        this.javaTypeMapper = javaTypeMapper;
    }

    public void setJsonObjectMapper(ObjectMapper jsonObjectMapper) {
        this.jsonObjectMapper = jsonObjectMapper;
    }

    protected void initializeJsonObjectMapper() {
        this.jsonObjectMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public Object fromMessage(Message message) throws MessageConversionException {
        Object content = null;
        MessageProperties properties = message.getMessageProperties();
        if (properties != null) {
            String contentType = properties.getContentType();
            if (contentType != null && contentType.contains("json")) {
                String encoding = properties.getContentEncoding();
                if (encoding == null) {
                    encoding = this.defaultCharset;
                }
                try {
                    if (this.getClassMapper() == null) {
                        JavaType targetJavaType = this.getJavaTypeMapper().toJavaType(message.getMessageProperties());
                        content = this.convertBytesToObject(message.getBody(), encoding, targetJavaType);
                    }
                    Class<?> targetClass = this.getClassMapper().toClass(message.getMessageProperties());
                    content = this.convertBytesToObject(message.getBody(), encoding, targetClass);
                }
                catch (UnsupportedEncodingException e) {
                    throw new MessageConversionException("Failed to convert json-based Message content", e);
                }
                catch (JsonParseException e) {
                    throw new MessageConversionException("Failed to convert Message content", e);
                }
                catch (JsonMappingException e) {
                    throw new MessageConversionException("Failed to convert Message content", e);
                }
                catch (IOException e) {
                    throw new MessageConversionException("Failed to convert Message content", e);
                }
            } else {
                log.warn((Object)("Could not convert incoming message with content-type [" + contentType + "]"));
            }
        }
        if (content == null) {
            content = message.getBody();
        }
        return content;
    }

    private Object convertBytesToObject(byte[] body, String encoding, JavaType targetJavaType) throws JsonParseException, JsonMappingException, IOException {
        String contentAsString = new String(body, encoding);
        return this.jsonObjectMapper.readValue(contentAsString, targetJavaType);
    }

    private Object convertBytesToObject(byte[] body, String encoding, Class<?> targetClass) throws JsonParseException, JsonMappingException, IOException {
        String contentAsString = new String(body, encoding);
        return this.jsonObjectMapper.readValue(contentAsString, TypeFactory.type(targetClass));
    }

    @Override
    protected Message createMessage(Object objectToConvert, MessageProperties messageProperties) throws MessageConversionException {
        byte[] bytes = null;
        try {
            String jsonString = this.jsonObjectMapper.writeValueAsString(objectToConvert);
            bytes = jsonString.getBytes(this.defaultCharset);
        }
        catch (UnsupportedEncodingException e) {
            throw new MessageConversionException("Failed to convert Message content", e);
        }
        catch (JsonGenerationException e) {
            throw new MessageConversionException("Failed to convert Message content", e);
        }
        catch (JsonMappingException e) {
            throw new MessageConversionException("Failed to convert Message content", e);
        }
        catch (IOException e) {
            throw new MessageConversionException("Failed to convert Message content", e);
        }
        messageProperties.setContentType("application/json");
        messageProperties.setContentEncoding(this.defaultCharset);
        if (bytes != null) {
            messageProperties.setContentLength(bytes.length);
        }
        if (this.getClassMapper() == null) {
            this.getJavaTypeMapper().fromJavaType(TypeFactory.type(objectToConvert.getClass()), messageProperties);
        } else {
            this.getClassMapper().fromClass(objectToConvert.getClass(), messageProperties);
        }
        return new Message(bytes, messageProperties);
    }
}

