/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.AbstractJavaTypeMapper;
import org.springframework.amqp.support.converter.ClassMapper;
import org.springframework.amqp.support.converter.Jackson2JavaTypeMapper;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class DefaultJackson2JavaTypeMapper
extends AbstractJavaTypeMapper
implements Jackson2JavaTypeMapper,
ClassMapper {
    private static final List<String> TRUSTED_PACKAGES = Arrays.asList("java.util", "java.lang");
    private final Set<String> trustedPackages = new LinkedHashSet<String>(TRUSTED_PACKAGES);
    private volatile Jackson2JavaTypeMapper.TypePrecedence typePrecedence = Jackson2JavaTypeMapper.TypePrecedence.INFERRED;

    public DefaultJackson2JavaTypeMapper() {
        this("*");
    }

    public DefaultJackson2JavaTypeMapper(String ... trustedPackages) {
        this.setTrustedPackages(trustedPackages);
    }

    @Override
    public Jackson2JavaTypeMapper.TypePrecedence getTypePrecedence() {
        return this.typePrecedence;
    }

    public void setTypePrecedence(Jackson2JavaTypeMapper.TypePrecedence typePrecedence) {
        Assert.notNull((Object)((Object)typePrecedence), (String)"'typePrecedence' cannot be null");
        this.typePrecedence = typePrecedence;
    }

    public final void setTrustedPackages(String ... trustedPackages) {
        if (trustedPackages != null) {
            for (String whiteListClass : trustedPackages) {
                if ("*".equals(whiteListClass)) {
                    this.trustedPackages.clear();
                    break;
                }
                if (this.trustedPackages.size() == 0) {
                    this.trustedPackages.addAll(TRUSTED_PACKAGES);
                }
                this.trustedPackages.add(whiteListClass);
            }
        }
    }

    @Override
    public JavaType toJavaType(MessageProperties properties) {
        JavaType targetType;
        boolean hasInferredTypeHeader = this.hasInferredTypeHeader(properties);
        if (hasInferredTypeHeader && this.typePrecedence.equals((Object)Jackson2JavaTypeMapper.TypePrecedence.INFERRED) && (!(targetType = this.fromInferredTypeHeader(properties)).isAbstract() && !targetType.isInterface() || targetType.getRawClass().getPackage().getName().startsWith("java.util"))) {
            return targetType;
        }
        String typeIdHeader = this.retrieveHeaderAsString(properties, this.getClassIdFieldName());
        if (typeIdHeader != null) {
            JavaType classType = this.getClassIdType(typeIdHeader);
            if (!classType.isContainerType() || classType.isArrayType()) {
                return classType;
            }
            JavaType contentClassType = this.getClassIdType(this.retrieveHeader(properties, this.getContentClassIdFieldName()));
            if (classType.getKeyType() == null) {
                return CollectionType.construct((Class)classType.getRawClass(), (JavaType)contentClassType);
            }
            JavaType keyClassType = this.getClassIdType(this.retrieveHeader(properties, this.getKeyClassIdFieldName()));
            return MapType.construct((Class)classType.getRawClass(), (JavaType)keyClassType, (JavaType)contentClassType);
        }
        if (hasInferredTypeHeader) {
            return this.fromInferredTypeHeader(properties);
        }
        return TypeFactory.defaultInstance().constructType(Object.class);
    }

    private JavaType getClassIdType(String classId) {
        if (this.getIdClassMapping().containsKey(classId)) {
            return TypeFactory.defaultInstance().constructType((Type)this.getIdClassMapping().get(classId));
        }
        try {
            if (!this.isTrustedPackage(classId)) {
                throw new IllegalArgumentException("The class '" + classId + "' is not in the trusted packages: " + this.trustedPackages + ". If you believe this class is safe to deserialize, please provide its name. If the serialization is only done by a trusted source, you can also enable trust all (*).");
            }
            return TypeFactory.defaultInstance().constructType((Type)ClassUtils.forName((String)classId, (ClassLoader)this.getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new MessageConversionException("failed to resolve class name. Class not found [" + classId + "]", e);
        }
        catch (LinkageError e) {
            throw new MessageConversionException("failed to resolve class name. Linkage error [" + classId + "]", e);
        }
    }

    private boolean isTrustedPackage(String requestedType) {
        if (!this.trustedPackages.isEmpty()) {
            String packageName = ClassUtils.getPackageName((String)requestedType).replaceFirst("\\[L", "");
            for (String trustedPackage : this.trustedPackages) {
                if (!packageName.equals(trustedPackage)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void fromJavaType(JavaType javaType, MessageProperties properties) {
        this.addHeader(properties, this.getClassIdFieldName(), javaType.getRawClass());
        if (javaType.isContainerType() && !javaType.isArrayType()) {
            this.addHeader(properties, this.getContentClassIdFieldName(), javaType.getContentType().getRawClass());
        }
        if (javaType.getKeyType() != null) {
            this.addHeader(properties, this.getKeyClassIdFieldName(), javaType.getKeyType().getRawClass());
        }
    }

    @Override
    public void fromClass(Class<?> clazz, MessageProperties properties) {
        this.fromJavaType(TypeFactory.defaultInstance().constructType(clazz), properties);
    }

    @Override
    public Class<?> toClass(MessageProperties properties) {
        return this.toJavaType(properties).getRawClass();
    }
}

