/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.NativeMessageHeaderAccessor;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;

public class AmqpMessageHeaderAccessor
extends NativeMessageHeaderAccessor {
    public static final String PRIORITY = "priority";

    protected AmqpMessageHeaderAccessor(Map<String, List<String>> nativeHeaders) {
        super(nativeHeaders);
    }

    protected AmqpMessageHeaderAccessor(Message<?> message) {
        super(message);
    }

    public static AmqpMessageHeaderAccessor wrap(Message<?> message) {
        return new AmqpMessageHeaderAccessor(message);
    }

    protected void verifyType(String headerName, Object headerValue) {
        super.verifyType(headerName, headerValue);
        if (PRIORITY.equals(headerName)) {
            Assert.isTrue((boolean)Integer.class.isAssignableFrom(headerValue.getClass()), (String)("The '" + headerName + "' header value must be an Integer."));
        }
    }

    public String getAppId() {
        return (String)this.getHeader("amqp_appId");
    }

    public String getClusterId() {
        return (String)this.getHeader("amqp_clusterId");
    }

    public String getContentEncoding() {
        return (String)this.getHeader("amqp_contentEncoding");
    }

    public Long getContentLength() {
        return (Long)this.getHeader("amqp_contentLength");
    }

    public MimeType getContentType() {
        Object value = this.getHeader("contentType");
        if (value instanceof String) {
            return MimeType.valueOf((String)((String)value));
        }
        return super.getContentType();
    }

    public String getCorrelationId() {
        return (String)this.getHeader("amqp_correlationId");
    }

    public MessageDeliveryMode getDeliveryMode() {
        return (MessageDeliveryMode)((Object)this.getHeader("amqp_deliveryMode"));
    }

    public MessageDeliveryMode getReceivedDeliveryMode() {
        return (MessageDeliveryMode)((Object)this.getHeader("amqp_receivedDeliveryMode"));
    }

    public Long getDeliveryTag() {
        return (Long)this.getHeader("amqp_deliveryTag");
    }

    public String getExpiration() {
        return (String)this.getHeader("amqp_expiration");
    }

    public Integer getMessageCount() {
        return (Integer)this.getHeader("amqp_messageCount");
    }

    public String getMessageId() {
        return (String)this.getHeader("amqp_messageId");
    }

    public Integer getPriority() {
        return (Integer)this.getHeader(PRIORITY);
    }

    public String getReceivedExchange() {
        return (String)this.getHeader("amqp_receivedExchange");
    }

    public String getReceivedRoutingKey() {
        return (String)this.getHeader("amqp_receivedRoutingKey");
    }

    public String getReceivedUserId() {
        return (String)this.getHeader("amqp_receivedUserId");
    }

    public Boolean getRedelivered() {
        return (Boolean)this.getHeader("amqp_redelivered");
    }

    public String getReplyTo() {
        return (String)this.getHeader("amqp_replyTo");
    }

    public Long getTimestamp() {
        Date amqpTimestamp = (Date)this.getHeader("amqp_timestamp");
        if (amqpTimestamp != null) {
            return amqpTimestamp.getTime();
        }
        return super.getTimestamp();
    }

    public String getType() {
        return (String)this.getHeader("amqp_type");
    }

    public String getUserId() {
        return (String)this.getHeader("amqp_userId");
    }

    public String getConsumerTag() {
        return (String)this.getHeader("amqp_consumerTag");
    }

    public String getConsumerQueue() {
        return (String)this.getHeader("amqp_consumerQueue");
    }
}

