/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.support;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.FlowListener;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.Method;
import com.rabbitmq.client.ReturnListener;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.rabbit.support.PendingConfirm;
import org.springframework.amqp.rabbit.support.PublisherCallbackChannel;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class PublisherCallbackChannelImpl
implements PublisherCallbackChannel,
ConfirmListener,
ReturnListener,
ShutdownListener {
    private static final String[] METHODS_OF_INTEREST = new String[]{"getFlow", "flow", "flowBlocked", "basicConsume", "basicQos"};
    private static final ReflectionUtils.MethodFilter METHOD_FILTER = new ReflectionUtils.MethodFilter(){

        public boolean matches(java.lang.reflect.Method method) {
            return ObjectUtils.containsElement((Object[])METHODS_OF_INTEREST, (Object)method.getName());
        }
    };
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Channel delegate;
    private final Map<String, PublisherCallbackChannel.Listener> listeners = new ConcurrentHashMap<String, PublisherCallbackChannel.Listener>();
    private final Map<PublisherCallbackChannel.Listener, SortedMap<Long, PendingConfirm>> pendingConfirms = new ConcurrentHashMap<PublisherCallbackChannel.Listener, SortedMap<Long, PendingConfirm>>();
    private final SortedMap<Long, PublisherCallbackChannel.Listener> listenerForSeq = new ConcurrentSkipListMap<Long, PublisherCallbackChannel.Listener>();
    private final java.lang.reflect.Method getFlowMethod;
    private final java.lang.reflect.Method flowMethod;
    private final java.lang.reflect.Method flowBlockedMethod;
    private final java.lang.reflect.Method basicConsumeFourArgsMethod;
    private final java.lang.reflect.Method basicQosTwoArgsMethod;

    public PublisherCallbackChannelImpl(Channel delegate) {
        delegate.addShutdownListener((ShutdownListener)this);
        this.delegate = delegate;
        final AtomicReference getFlowMethod = new AtomicReference();
        final AtomicReference flowMethod = new AtomicReference();
        final AtomicReference flowBlockedMethod = new AtomicReference();
        final AtomicReference basicConsumeFourArgsMethod = new AtomicReference();
        final AtomicReference basicQosTwoArgsMethod = new AtomicReference();
        ReflectionUtils.doWithMethods(delegate.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(java.lang.reflect.Method method) throws IllegalArgumentException, IllegalAccessException {
                if ("getFlow".equals(method.getName()) && method.getParameterTypes().length == 0 && AMQP.Channel.FlowOk.class.equals(method.getReturnType())) {
                    getFlowMethod.set(method);
                } else if ("flow".equals(method.getName()) && method.getParameterTypes().length == 1 && Boolean.TYPE.equals(method.getParameterTypes()[0]) && AMQP.Channel.FlowOk.class.equals(method.getReturnType())) {
                    flowMethod.set(method);
                } else if ("flowBlocked".equals(method.getName()) && method.getParameterTypes().length == 0 && Boolean.TYPE.equals(method.getReturnType())) {
                    flowBlockedMethod.set(method);
                } else if ("basicConsume".equals(method.getName()) && method.getParameterTypes().length == 4 && String.class.equals(method.getParameterTypes()[0]) && Boolean.TYPE.equals(method.getParameterTypes()[1]) && Map.class.equals(method.getParameterTypes()[2]) && Consumer.class.equals(method.getParameterTypes()[3]) && String.class.equals(method.getReturnType())) {
                    basicConsumeFourArgsMethod.set(method);
                } else if ("basicQos".equals(method.getName()) && method.getParameterTypes().length == 2 && Integer.TYPE.equals(method.getParameterTypes()[0]) && Boolean.TYPE.equals(method.getParameterTypes()[1]) && Void.TYPE.equals(method.getReturnType())) {
                    basicQosTwoArgsMethod.set(method);
                }
            }
        }, (ReflectionUtils.MethodFilter)METHOD_FILTER);
        this.getFlowMethod = (java.lang.reflect.Method)getFlowMethod.get();
        this.flowMethod = (java.lang.reflect.Method)flowMethod.get();
        this.flowBlockedMethod = (java.lang.reflect.Method)flowBlockedMethod.get();
        this.basicConsumeFourArgsMethod = (java.lang.reflect.Method)basicConsumeFourArgsMethod.get();
        this.basicQosTwoArgsMethod = (java.lang.reflect.Method)basicQosTwoArgsMethod.get();
    }

    public void addShutdownListener(ShutdownListener listener) {
        this.delegate.addShutdownListener(listener);
    }

    public void removeShutdownListener(ShutdownListener listener) {
        this.delegate.removeShutdownListener(listener);
    }

    public ShutdownSignalException getCloseReason() {
        return this.delegate.getCloseReason();
    }

    public void notifyListeners() {
        this.delegate.notifyListeners();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public int getChannelNumber() {
        return this.delegate.getChannelNumber();
    }

    public Connection getConnection() {
        return this.delegate.getConnection();
    }

    public void close(int closeCode, String closeMessage) throws IOException {
        this.delegate.close(closeCode, closeMessage);
    }

    @Deprecated
    public AMQP.Channel.FlowOk flow(boolean active) throws IOException {
        if (this.flowMethod != null) {
            return (AMQP.Channel.FlowOk)ReflectionUtils.invokeMethod((java.lang.reflect.Method)this.flowMethod, (Object)this.delegate, (Object[])new Object[]{active});
        }
        throw new UnsupportedOperationException("'flow(boolean)' is not supported by the client library");
    }

    @Deprecated
    public AMQP.Channel.FlowOk getFlow() {
        if (this.getFlowMethod != null) {
            return (AMQP.Channel.FlowOk)ReflectionUtils.invokeMethod((java.lang.reflect.Method)this.getFlowMethod, (Object)this.delegate);
        }
        throw new UnsupportedOperationException("'getFlow()' is not supported by the client library");
    }

    public boolean flowBlocked() {
        if (this.flowBlockedMethod != null) {
            return (Boolean)ReflectionUtils.invokeMethod((java.lang.reflect.Method)this.flowBlockedMethod, (Object)this.delegate);
        }
        throw new UnsupportedOperationException("'flowBlocked()' is not supported by the client library");
    }

    public void abort() throws IOException {
        this.delegate.abort();
    }

    public void abort(int closeCode, String closeMessage) throws IOException {
        this.delegate.abort(closeCode, closeMessage);
    }

    public void addFlowListener(FlowListener listener) {
        this.delegate.addFlowListener(listener);
    }

    public boolean removeFlowListener(FlowListener listener) {
        return this.delegate.removeFlowListener(listener);
    }

    public void clearFlowListeners() {
        this.delegate.clearFlowListeners();
    }

    public Consumer getDefaultConsumer() {
        return this.delegate.getDefaultConsumer();
    }

    public void setDefaultConsumer(Consumer consumer) {
        this.delegate.setDefaultConsumer(consumer);
    }

    public void basicQos(int prefetchSize, int prefetchCount, boolean global) throws IOException {
        this.delegate.basicQos(prefetchSize, prefetchCount, global);
    }

    public void basicQos(int prefetchCount, boolean global) throws IOException {
        if (this.basicQosTwoArgsMethod != null) {
            ReflectionUtils.invokeMethod((java.lang.reflect.Method)this.basicQosTwoArgsMethod, (Object)this.delegate, (Object[])new Object[]{prefetchCount, global});
            return;
        }
        throw new UnsupportedOperationException("'basicQos(int, boolean)' is not supported by the client library");
    }

    public void basicQos(int prefetchCount) throws IOException {
        this.delegate.basicQos(prefetchCount);
    }

    public void basicPublish(String exchange, String routingKey, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.delegate.basicPublish(exchange, routingKey, props, body);
    }

    public void basicPublish(String exchange, String routingKey, boolean mandatory, boolean immediate, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.delegate.basicPublish(exchange, routingKey, mandatory, props, body);
    }

    public void basicPublish(String exchange, String routingKey, boolean mandatory, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.delegate.basicPublish(exchange, routingKey, mandatory, props, body);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type) throws IOException {
        return this.delegate.exchangeDeclare(exchange, type);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable) throws IOException {
        return this.delegate.exchangeDeclare(exchange, type, durable);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        return this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, arguments);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
        return this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, internal, arguments);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclarePassive(String name) throws IOException {
        return this.delegate.exchangeDeclarePassive(name);
    }

    public AMQP.Exchange.DeleteOk exchangeDelete(String exchange, boolean ifUnused) throws IOException {
        return this.delegate.exchangeDelete(exchange, ifUnused);
    }

    public AMQP.Exchange.DeleteOk exchangeDelete(String exchange) throws IOException {
        return this.delegate.exchangeDelete(exchange);
    }

    public AMQP.Exchange.BindOk exchangeBind(String destination, String source, String routingKey) throws IOException {
        return this.delegate.exchangeBind(destination, source, routingKey);
    }

    public AMQP.Exchange.BindOk exchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
        return this.delegate.exchangeBind(destination, source, routingKey, arguments);
    }

    public AMQP.Exchange.UnbindOk exchangeUnbind(String destination, String source, String routingKey) throws IOException {
        return this.delegate.exchangeUnbind(destination, source, routingKey);
    }

    public AMQP.Exchange.UnbindOk exchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
        return this.delegate.exchangeUnbind(destination, source, routingKey, arguments);
    }

    public AMQP.Queue.DeclareOk queueDeclare() throws IOException {
        return this.delegate.queueDeclare();
    }

    public AMQP.Queue.DeclareOk queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        return this.delegate.queueDeclare(queue, durable, exclusive, autoDelete, arguments);
    }

    public AMQP.Queue.DeclareOk queueDeclarePassive(String queue) throws IOException {
        return this.delegate.queueDeclarePassive(queue);
    }

    public AMQP.Queue.DeleteOk queueDelete(String queue) throws IOException {
        return this.delegate.queueDelete(queue);
    }

    public AMQP.Queue.DeleteOk queueDelete(String queue, boolean ifUnused, boolean ifEmpty) throws IOException {
        return this.delegate.queueDelete(queue, ifUnused, ifEmpty);
    }

    public AMQP.Queue.BindOk queueBind(String queue, String exchange, String routingKey) throws IOException {
        return this.delegate.queueBind(queue, exchange, routingKey);
    }

    public AMQP.Queue.BindOk queueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
        return this.delegate.queueBind(queue, exchange, routingKey, arguments);
    }

    public AMQP.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey) throws IOException {
        return this.delegate.queueUnbind(queue, exchange, routingKey);
    }

    public AMQP.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
        return this.delegate.queueUnbind(queue, exchange, routingKey, arguments);
    }

    public AMQP.Queue.PurgeOk queuePurge(String queue) throws IOException {
        return this.delegate.queuePurge(queue);
    }

    public GetResponse basicGet(String queue, boolean autoAck) throws IOException {
        return this.delegate.basicGet(queue, autoAck);
    }

    public void basicAck(long deliveryTag, boolean multiple) throws IOException {
        this.delegate.basicAck(deliveryTag, multiple);
    }

    public void basicNack(long deliveryTag, boolean multiple, boolean requeue) throws IOException {
        this.delegate.basicNack(deliveryTag, multiple, requeue);
    }

    public void basicReject(long deliveryTag, boolean requeue) throws IOException {
        this.delegate.basicReject(deliveryTag, requeue);
    }

    public String basicConsume(String queue, Consumer callback) throws IOException {
        return this.delegate.basicConsume(queue, callback);
    }

    public String basicConsume(String queue, boolean autoAck, Consumer callback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, callback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, Consumer callback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, consumerTag, callback);
    }

    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, Consumer callback) throws IOException {
        if (this.basicConsumeFourArgsMethod != null) {
            return (String)ReflectionUtils.invokeMethod((java.lang.reflect.Method)this.basicConsumeFourArgsMethod, (Object)this.delegate, (Object[])new Object[]{queue, autoAck, arguments, callback});
        }
        throw new UnsupportedOperationException("'basicConsume(String, boolean, Map, Consumer)' is not supported by the client library");
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, Consumer callback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, callback);
    }

    public void basicCancel(String consumerTag) throws IOException {
        this.delegate.basicCancel(consumerTag);
    }

    public AMQP.Basic.RecoverOk basicRecover() throws IOException {
        return this.delegate.basicRecover();
    }

    public AMQP.Basic.RecoverOk basicRecover(boolean requeue) throws IOException {
        return this.delegate.basicRecover(requeue);
    }

    @Deprecated
    public void basicRecoverAsync(boolean requeue) throws IOException {
        this.delegate.basicRecover(requeue);
    }

    public AMQP.Tx.SelectOk txSelect() throws IOException {
        return this.delegate.txSelect();
    }

    public AMQP.Tx.CommitOk txCommit() throws IOException {
        return this.delegate.txCommit();
    }

    public AMQP.Tx.RollbackOk txRollback() throws IOException {
        return this.delegate.txRollback();
    }

    public AMQP.Confirm.SelectOk confirmSelect() throws IOException {
        return this.delegate.confirmSelect();
    }

    public long getNextPublishSeqNo() {
        return this.delegate.getNextPublishSeqNo();
    }

    public boolean waitForConfirms() throws InterruptedException {
        return this.delegate.waitForConfirms();
    }

    public boolean waitForConfirms(long timeout) throws InterruptedException, TimeoutException {
        return this.delegate.waitForConfirms(timeout);
    }

    public void waitForConfirmsOrDie() throws IOException, InterruptedException {
        this.delegate.waitForConfirmsOrDie();
    }

    public void waitForConfirmsOrDie(long timeout) throws IOException, InterruptedException, TimeoutException {
        this.delegate.waitForConfirmsOrDie(timeout);
    }

    public void asyncRpc(Method method) throws IOException {
        this.delegate.asyncRpc(method);
    }

    public Command rpc(Method method) throws IOException {
        return this.delegate.rpc(method);
    }

    public void addConfirmListener(ConfirmListener listener) {
        this.delegate.addConfirmListener(listener);
    }

    public boolean removeConfirmListener(ConfirmListener listener) {
        return this.delegate.removeConfirmListener(listener);
    }

    public void clearConfirmListeners() {
        this.delegate.clearConfirmListeners();
    }

    public void addReturnListener(ReturnListener listener) {
        this.delegate.addReturnListener(listener);
    }

    public boolean removeReturnListener(ReturnListener listener) {
        return this.delegate.removeReturnListener(listener);
    }

    public synchronized void clearReturnListeners() {
        this.delegate.clearReturnListeners();
    }

    public void exchangeBindNoWait(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
        throw new UnsupportedOperationException("To use the ...NoWait methods, use getDelegate().");
    }

    public void exchangeDeclareNoWait(String exchange, String type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
        throw new UnsupportedOperationException("To use the ...NoWait methods, use getDelegate().");
    }

    public void exchangeDeleteNoWait(String exchange, boolean ifUnused) throws IOException {
        throw new UnsupportedOperationException("To use the ...NoWait methods, use getDelegate().");
    }

    public void exchangeUnbindNoWait(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
        throw new UnsupportedOperationException("To use the ...NoWait methods, use getDelegate().");
    }

    public void queueBindNoWait(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
        throw new UnsupportedOperationException("To use the ...NoWait methods, use getDelegate().");
    }

    public void queueDeclareNoWait(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        throw new UnsupportedOperationException("To use the ...NoWait methods, use getDelegate().");
    }

    public void queueDeleteNoWait(String queue, boolean ifUnused, boolean ifEmpty) throws IOException {
        throw new UnsupportedOperationException("To use the ...NoWait methods, use getDelegate().");
    }

    @Override
    public Channel getDelegate() {
        return this.delegate;
    }

    public void close() throws IOException {
        block2: {
            try {
                this.delegate.close();
            }
            catch (AlreadyClosedException e) {
                if (!this.logger.isTraceEnabled()) break block2;
                this.logger.trace((Object)(this.delegate + " is already closed"));
            }
        }
        this.generateNacksForPendingAcks("Channel closed by application");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateNacksForPendingAcks(String cause) {
        Map<PublisherCallbackChannel.Listener, SortedMap<Long, PendingConfirm>> map = this.pendingConfirms;
        synchronized (map) {
            for (Map.Entry<PublisherCallbackChannel.Listener, SortedMap<Long, PendingConfirm>> entry : this.pendingConfirms.entrySet()) {
                PublisherCallbackChannel.Listener listener = entry.getKey();
                for (Map.Entry<Long, PendingConfirm> confirmEntry : entry.getValue().entrySet()) {
                    try {
                        confirmEntry.getValue().setCause(cause);
                        this.handleNack(confirmEntry.getKey(), false);
                    }
                    catch (IOException e) {
                        this.logger.error((Object)"Error delivering Nack afterShutdown", (Throwable)e);
                    }
                }
                listener.removePendingConfirmsReference(this, entry.getValue());
            }
            this.pendingConfirms.clear();
            this.listenerForSeq.clear();
            this.listeners.clear();
        }
    }

    @Override
    public synchronized SortedMap<Long, PendingConfirm> addListener(PublisherCallbackChannel.Listener listener) {
        Assert.notNull((Object)listener, (String)"Listener cannot be null");
        if (this.listeners.size() == 0) {
            this.delegate.addConfirmListener((ConfirmListener)this);
            this.delegate.addReturnListener((ReturnListener)this);
        }
        if (!this.listeners.values().contains(listener)) {
            this.listeners.put(listener.getUUID(), listener);
            this.pendingConfirms.put(listener, Collections.synchronizedSortedMap(new TreeMap()));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Added listener " + listener));
            }
        }
        return this.pendingConfirms.get(listener);
    }

    @Override
    public synchronized boolean removeListener(PublisherCallbackChannel.Listener listener) {
        boolean result;
        PublisherCallbackChannel.Listener mappedListener = this.listeners.remove(listener.getUUID());
        boolean bl = result = mappedListener != null;
        if (result && this.listeners.size() == 0) {
            this.delegate.removeConfirmListener((ConfirmListener)this);
            this.delegate.removeReturnListener((ReturnListener)this);
        }
        Iterator<Map.Entry<Long, PublisherCallbackChannel.Listener>> iterator = this.listenerForSeq.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, PublisherCallbackChannel.Listener> entry = iterator.next();
            if (entry.getValue() != listener) continue;
            iterator.remove();
        }
        this.pendingConfirms.remove(listener);
        return result;
    }

    public void handleAck(long seq, boolean multiple) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.toString() + " PC:Ack:" + seq + ":" + multiple));
        }
        this.processAck(seq, true, multiple);
    }

    public void handleNack(long seq, boolean multiple) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.toString() + " PC:Nack:" + seq + ":" + multiple));
        }
        this.processAck(seq, false, multiple);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAck(long seq, boolean ack, boolean multiple) {
        if (multiple) {
            Map<PublisherCallbackChannel.Listener, SortedMap<Long, PendingConfirm>> map = this.pendingConfirms;
            synchronized (map) {
                SortedMap<Long, PublisherCallbackChannel.Listener> involvedListeners = this.listenerForSeq.headMap(seq + 1L);
                HashSet listeners = new HashSet(involvedListeners.values());
                for (PublisherCallbackChannel.Listener involvedListener : listeners) {
                    SortedMap<Long, PendingConfirm> confirmsMap = this.pendingConfirms.get(involvedListener);
                    if (confirmsMap == null) continue;
                    SortedMap<Long, PendingConfirm> confirms = confirmsMap.headMap(seq + 1L);
                    Iterator iterator = confirms.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        PendingConfirm value = (PendingConfirm)entry.getValue();
                        iterator.remove();
                        this.doHandleConfirm(ack, involvedListener, value);
                    }
                }
                ArrayList seqs = new ArrayList(involvedListeners.keySet());
                for (Long key : seqs) {
                    this.listenerForSeq.remove(key);
                }
            }
        } else {
            PublisherCallbackChannel.Listener listener = (PublisherCallbackChannel.Listener)this.listenerForSeq.remove(seq);
            if (listener != null) {
                PendingConfirm pendingConfirm = (PendingConfirm)this.pendingConfirms.get(listener).remove(seq);
                if (pendingConfirm != null) {
                    this.doHandleConfirm(ack, listener, pendingConfirm);
                }
            } else {
                this.logger.error((Object)("No listener for seq:" + seq));
            }
        }
    }

    private void doHandleConfirm(boolean ack, PublisherCallbackChannel.Listener listener, PendingConfirm pendingConfirm) {
        try {
            if (listener.isConfirmListener()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Sending confirm " + pendingConfirm));
                }
                listener.handleConfirm(pendingConfirm, ack);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception delivering confirm", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPendingConfirm(PublisherCallbackChannel.Listener listener, long seq, PendingConfirm pendingConfirm) {
        SortedMap<Long, PendingConfirm> pendingConfirmsForListener = this.pendingConfirms.get(listener);
        Assert.notNull(pendingConfirmsForListener, (String)"Listener not registered");
        Map<PublisherCallbackChannel.Listener, SortedMap<Long, PendingConfirm>> map = this.pendingConfirms;
        synchronized (map) {
            pendingConfirmsForListener.put(seq, pendingConfirm);
        }
        this.listenerForSeq.put(seq, listener);
    }

    public void handleReturn(int replyCode, String replyText, String exchange, String routingKey, AMQP.BasicProperties properties, byte[] body) throws IOException {
        String uuidObject = properties.getHeaders().get("spring_return_correlation").toString();
        PublisherCallbackChannel.Listener listener = this.listeners.get(uuidObject);
        if (listener == null || !listener.isReturnListener()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"No Listener for returned message");
            }
        } else {
            listener.handleReturn(replyCode, replyText, exchange, routingKey, properties, body);
        }
    }

    public void shutdownCompleted(ShutdownSignalException cause) {
        this.generateNacksForPendingAcks(cause.getMessage());
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || this.delegate.equals(obj);
    }

    public String toString() {
        return "PublisherCallbackChannelImpl: " + this.delegate.toString();
    }
}

