/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.annotation.RabbitListenerConfigurer;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.listener.MethodRabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.MultiMethodRabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistrar;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class RabbitListenerAnnotationBeanPostProcessor
implements BeanPostProcessor,
Ordered,
BeanFactoryAware,
SmartInitializingSingleton {
    static final String DEFAULT_RABBIT_LISTENER_CONTAINER_FACTORY_BEAN_NAME = "rabbitListenerContainerFactory";
    private RabbitListenerEndpointRegistry endpointRegistry;
    private String containerFactoryBeanName = "rabbitListenerContainerFactory";
    private BeanFactory beanFactory;
    private final RabbitHandlerMethodFactoryAdapter messageHandlerMethodFactory = new RabbitHandlerMethodFactoryAdapter();
    private final RabbitListenerEndpointRegistrar registrar = new RabbitListenerEndpointRegistrar();
    private final AtomicInteger counter = new AtomicInteger();
    private BeanExpressionResolver resolver = new StandardBeanExpressionResolver();
    private BeanExpressionContext expressionContext;
    private int increment;

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setEndpointRegistry(RabbitListenerEndpointRegistry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }

    public void setContainerFactoryBeanName(String containerFactoryBeanName) {
        this.containerFactoryBeanName = containerFactoryBeanName;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory.setMessageHandlerMethodFactory(messageHandlerMethodFactory);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.resolver = ((ConfigurableListableBeanFactory)beanFactory).getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)((ConfigurableListableBeanFactory)beanFactory), null);
        }
    }

    public void afterSingletonsInstantiated() {
        MessageHandlerMethodFactory handlerMethodFactory;
        this.registrar.setBeanFactory(this.beanFactory);
        if (this.beanFactory instanceof ListableBeanFactory) {
            Map instances = ((ListableBeanFactory)this.beanFactory).getBeansOfType(RabbitListenerConfigurer.class);
            for (RabbitListenerConfigurer configurer : instances.values()) {
                configurer.configureRabbitListeners(this.registrar);
            }
        }
        if (this.registrar.getEndpointRegistry() == null) {
            if (this.endpointRegistry == null) {
                Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to find endpoint registry by bean name");
                this.endpointRegistry = (RabbitListenerEndpointRegistry)this.beanFactory.getBean("org.springframework.amqp.rabbit.config.internalRabbitListenerEndpointRegistry", RabbitListenerEndpointRegistry.class);
            }
            this.registrar.setEndpointRegistry(this.endpointRegistry);
        }
        if (this.containerFactoryBeanName != null) {
            this.registrar.setContainerFactoryBeanName(this.containerFactoryBeanName);
        }
        if ((handlerMethodFactory = this.registrar.getMessageHandlerMethodFactory()) != null) {
            this.messageHandlerMethodFactory.setMessageHandlerMethodFactory(handlerMethodFactory);
        }
        this.registrar.afterPropertiesSet();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(final Object bean, final String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        final RabbitListener classLevelListener = (RabbitListener)AnnotationUtils.findAnnotation(bean.getClass(), RabbitListener.class);
        final ArrayList<Method> multiMethods = new ArrayList<Method>();
        ReflectionUtils.doWithMethods((Class)targetClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                RabbitHandler rabbitHandler;
                RabbitListener rabbitListener = (RabbitListener)AnnotationUtils.getAnnotation((Method)method, RabbitListener.class);
                if (rabbitListener != null) {
                    RabbitListenerAnnotationBeanPostProcessor.this.processAmqpListener(rabbitListener, method, bean, beanName);
                }
                if (classLevelListener != null && (rabbitHandler = (RabbitHandler)AnnotationUtils.getAnnotation((Method)method, RabbitHandler.class)) != null) {
                    multiMethods.add(method);
                }
            }
        });
        if (classLevelListener != null) {
            this.processMultiMethodListener(classLevelListener, multiMethods, bean, beanName);
        }
        return bean;
    }

    private void processMultiMethodListener(RabbitListener classLevelListener, List<Method> multiMethods, Object bean, String beanName) {
        ArrayList<Method> checkedMethods = new ArrayList<Method>();
        for (Method method : multiMethods) {
            checkedMethods.add(this.checkProxy(method, bean));
        }
        MultiMethodRabbitListenerEndpoint endpoint = new MultiMethodRabbitListenerEndpoint(checkedMethods, bean);
        this.processListener(endpoint, classLevelListener, bean, bean.getClass(), beanName);
    }

    protected void processAmqpListener(RabbitListener rabbitListener, Method method, Object bean, String beanName) {
        Method methodToUse = this.checkProxy(method, bean);
        MethodRabbitListenerEndpoint endpoint = new MethodRabbitListenerEndpoint();
        endpoint.setMethod(methodToUse);
        endpoint.setBeanFactory(this.beanFactory);
        this.processListener(endpoint, rabbitListener, bean, methodToUse, beanName);
    }

    private Method checkProxy(Method method, Object bean) {
        if (AopUtils.isJdkDynamicProxy((Object)bean)) {
            try {
                method = bean.getClass().getMethod(method.getName(), method.getParameterTypes());
            }
            catch (SecurityException ex) {
                ReflectionUtils.handleReflectionException((Exception)ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException(String.format("@RabbitListener method '%s' found on bean target class '%s', but not found in any interface(s) for bean JDK proxy. Either pull the method up to an interface or switch to subclass (CGLIB) proxies by setting proxy-target-class/proxyTargetClass attribute to 'true'", method.getName(), method.getDeclaringClass().getSimpleName()));
            }
        }
        return method;
    }

    private void processListener(MethodRabbitListenerEndpoint endpoint, RabbitListener rabbitListener, Object bean, Object adminTarget, String beanName) {
        String rabbitAdmin;
        Object resolvedGroup;
        endpoint.setBean(bean);
        endpoint.setMessageHandlerMethodFactory(this.messageHandlerMethodFactory);
        endpoint.setId(this.getEndpointId(rabbitListener));
        endpoint.setQueueNames(this.resolveQueues(rabbitListener));
        String group = rabbitListener.group();
        if (StringUtils.hasText((String)group) && (resolvedGroup = this.resolveExpression(group)) instanceof String) {
            endpoint.setGroup((String)resolvedGroup);
        }
        endpoint.setExclusive(rabbitListener.exclusive());
        String priority = this.resolve(rabbitListener.priority());
        if (StringUtils.hasText((String)priority)) {
            try {
                endpoint.setPriority(Integer.valueOf(priority));
            }
            catch (NumberFormatException ex) {
                throw new BeanInitializationException("Invalid priority value for " + rabbitListener + " (must be an integer)", (Throwable)ex);
            }
        }
        if (StringUtils.hasText((String)(rabbitAdmin = this.resolve(rabbitListener.admin())))) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to resolve RabbitAdmin by bean name");
            try {
                endpoint.setAdmin((RabbitAdmin)this.beanFactory.getBean(rabbitAdmin, RabbitAdmin.class));
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new BeanInitializationException("Could not register rabbit listener endpoint on [" + adminTarget + "], no " + RabbitAdmin.class.getSimpleName() + " with id '" + rabbitAdmin + "' was found in the application context", (Throwable)ex);
            }
        }
        RabbitListenerContainerFactory factory = null;
        String containerFactoryBeanName = this.resolve(rabbitListener.containerFactory());
        if (StringUtils.hasText((String)containerFactoryBeanName)) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to obtain container factory by bean name");
            try {
                factory = (RabbitListenerContainerFactory)this.beanFactory.getBean(containerFactoryBeanName, RabbitListenerContainerFactory.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new BeanInitializationException("Could not register rabbit listener endpoint on [" + adminTarget + "] for bean " + beanName + ", no " + RabbitListenerContainerFactory.class.getSimpleName() + " with id '" + containerFactoryBeanName + "' was found in the application context", (Throwable)ex);
            }
        }
        this.registrar.registerEndpoint(endpoint, factory);
    }

    private String getEndpointId(RabbitListener rabbitListener) {
        if (StringUtils.hasText((String)rabbitListener.id())) {
            return this.resolve(rabbitListener.id());
        }
        return "org.springframework.amqp.rabbit.RabbitListenerEndpointContainer#" + this.counter.getAndIncrement();
    }

    private String[] resolveQueues(RabbitListener rabbitListener) {
        String[] queues = rabbitListener.queues();
        QueueBinding[] bindings = rabbitListener.bindings();
        if (queues.length > 0 && bindings.length > 0) {
            throw new BeanInitializationException("@RabbitListener can have 'queues' or 'bindings' but not both");
        }
        ArrayList<String> result = new ArrayList<String>();
        if (queues.length > 0) {
            for (int i = 0; i < queues.length; ++i) {
                Object resolvedValue = this.resolveExpression(queues[i]);
                this.resolveAsString(resolvedValue, result);
            }
        } else {
            return this.registerBeansForDeclaration(rabbitListener);
        }
        return result.toArray(new String[result.size()]);
    }

    private void resolveAsString(Object resolvedValue, List<String> result) {
        List<String> resolvedValueToUse = resolvedValue;
        if (resolvedValue instanceof String[]) {
            resolvedValueToUse = Arrays.asList((String[])resolvedValue);
        }
        if (resolvedValueToUse instanceof org.springframework.amqp.core.Queue) {
            result.add(((org.springframework.amqp.core.Queue)resolvedValueToUse).getName());
        } else if (resolvedValueToUse instanceof String) {
            result.add((String)((Object)resolvedValueToUse));
        } else if (resolvedValueToUse instanceof Iterable) {
            for (Object object : (Iterable)resolvedValueToUse) {
                this.resolveAsString(object, result);
            }
        } else {
            throw new IllegalArgumentException(String.format("@RabbitListener can't resolve '%s' as either a String or a Queue", resolvedValue));
        }
    }

    private Object resolveExpression(String value) {
        String resolvedValue = this.resolve(value);
        if (!resolvedValue.startsWith("#{") || !value.endsWith("}")) {
            return resolvedValue;
        }
        return this.resolver.evaluate(resolvedValue, this.expressionContext);
    }

    private String resolve(String value) {
        if (this.beanFactory != null && this.beanFactory instanceof ConfigurableBeanFactory) {
            return ((ConfigurableBeanFactory)this.beanFactory).resolveEmbeddedValue(value);
        }
        return value;
    }

    private String[] registerBeansForDeclaration(RabbitListener rabbitListener) {
        ArrayList<String> queues = new ArrayList<String>();
        if (this.beanFactory instanceof ConfigurableBeanFactory) {
            for (QueueBinding binding : rabbitListener.bindings()) {
                Queue bindingQueue = binding.value();
                String queueName = (String)this.resolveExpression(bindingQueue.value());
                boolean exclusive = false;
                boolean autoDelete = false;
                if (!StringUtils.hasText((String)queueName)) {
                    queueName = UUID.randomUUID().toString();
                    if (!StringUtils.hasText((String)bindingQueue.exclusive()) || this.resolveExpressionAsBoolean(bindingQueue.exclusive())) {
                        exclusive = true;
                    }
                    if (!StringUtils.hasText((String)bindingQueue.autoDelete()) || this.resolveExpressionAsBoolean(bindingQueue.autoDelete())) {
                        autoDelete = true;
                    }
                } else {
                    exclusive = this.resolveExpressionAsBoolean(bindingQueue.exclusive());
                    autoDelete = this.resolveExpressionAsBoolean(bindingQueue.autoDelete());
                }
                org.springframework.amqp.core.Queue queue = new org.springframework.amqp.core.Queue(queueName, this.resolveExpressionAsBoolean(bindingQueue.durable()), exclusive, autoDelete);
                ((ConfigurableBeanFactory)this.beanFactory).registerSingleton(queueName + ++this.increment, (Object)queue);
                queues.add(queueName);
                DirectExchange exchange = null;
                Exchange bindingExchange = binding.exchange();
                String exchangeName = (String)this.resolveExpression(bindingExchange.value());
                String exchangeType = bindingExchange.type();
                Binding actualBinding = null;
                Object key = this.resolveExpression(binding.key());
                if (!(key instanceof String)) {
                    throw new BeanInitializationException("key must resolved to a String, not: " + key.getClass().toString());
                }
                String resolvedKey = (String)key;
                if (exchangeType.equals("direct")) {
                    exchange = new DirectExchange(exchangeName, this.resolveExpressionAsBoolean(bindingExchange.durable()), this.resolveExpressionAsBoolean(bindingExchange.autoDelete()));
                    actualBinding = new Binding(queueName, Binding.DestinationType.QUEUE, exchangeName, resolvedKey, null);
                } else if (exchangeType.equals("fanout")) {
                    exchange = new FanoutExchange(exchangeName, this.resolveExpressionAsBoolean(bindingExchange.durable()), this.resolveExpressionAsBoolean(bindingExchange.autoDelete()));
                    actualBinding = new Binding(queueName, Binding.DestinationType.QUEUE, exchangeName, "", null);
                } else if (exchangeType.equals("topic")) {
                    exchange = new TopicExchange(exchangeName, this.resolveExpressionAsBoolean(bindingExchange.durable()), this.resolveExpressionAsBoolean(bindingExchange.autoDelete()));
                    actualBinding = new Binding(queueName, Binding.DestinationType.QUEUE, exchangeName, resolvedKey, null);
                } else {
                    throw new BeanInitializationException("Unexpected exchange type: " + exchangeType);
                }
                ((ConfigurableBeanFactory)this.beanFactory).registerSingleton(exchangeName + ++this.increment, (Object)exchange);
                ((ConfigurableBeanFactory)this.beanFactory).registerSingleton(exchangeName + ++this.increment, (Object)actualBinding);
            }
        }
        return queues.toArray(new String[queues.size()]);
    }

    private boolean resolveExpressionAsBoolean(String value) {
        Object resolved = this.resolveExpression(value);
        if (resolved instanceof Boolean) {
            return (Boolean)resolved;
        }
        if (resolved instanceof String) {
            return Boolean.valueOf((String)resolved);
        }
        return false;
    }

    private class RabbitHandlerMethodFactoryAdapter
    implements MessageHandlerMethodFactory {
        private MessageHandlerMethodFactory messageHandlerMethodFactory;

        private RabbitHandlerMethodFactoryAdapter() {
        }

        public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory rabbitHandlerMethodFactory1) {
            this.messageHandlerMethodFactory = rabbitHandlerMethodFactory1;
        }

        public InvocableHandlerMethod createInvocableHandlerMethod(Object bean, Method method) {
            return this.getMessageHandlerMethodFactory().createInvocableHandlerMethod(bean, method);
        }

        private MessageHandlerMethodFactory getMessageHandlerMethodFactory() {
            if (this.messageHandlerMethodFactory == null) {
                this.messageHandlerMethodFactory = this.createDefaultMessageHandlerMethodFactory();
            }
            return this.messageHandlerMethodFactory;
        }

        private MessageHandlerMethodFactory createDefaultMessageHandlerMethodFactory() {
            DefaultMessageHandlerMethodFactory defaultFactory = new DefaultMessageHandlerMethodFactory();
            defaultFactory.setBeanFactory(RabbitListenerAnnotationBeanPostProcessor.this.beanFactory);
            defaultFactory.afterPropertiesSet();
            return defaultFactory;
        }
    }
}

