/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpoint;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RabbitListenerEndpointRegistry
implements DisposableBean,
SmartLifecycle,
ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, MessageListenerContainer> listenerContainers = new ConcurrentHashMap<String, MessageListenerContainer>();
    private int phase = Integer.MAX_VALUE;
    private ConfigurableApplicationContext applicationContext;
    private boolean contextRefreshed;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        }
    }

    public MessageListenerContainer getListenerContainer(String id) {
        Assert.hasText((String)id, (String)"Container identifier must not be empty");
        return this.listenerContainers.get(id);
    }

    public Set<String> getListenerContainerIds() {
        return Collections.unmodifiableSet(this.listenerContainers.keySet());
    }

    public Collection<MessageListenerContainer> getListenerContainers() {
        return Collections.unmodifiableCollection(this.listenerContainers.values());
    }

    public void registerListenerContainer(RabbitListenerEndpoint endpoint, RabbitListenerContainerFactory<?> factory) {
        this.registerListenerContainer(endpoint, factory, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListenerContainer(RabbitListenerEndpoint endpoint, RabbitListenerContainerFactory<?> factory, boolean startImmediately) {
        Assert.notNull((Object)endpoint, (String)"Endpoint must not be null");
        Assert.notNull(factory, (String)"Factory must not be null");
        String id = endpoint.getId();
        Assert.hasText((String)id, (String)"Endpoint id must not be empty");
        Map<String, MessageListenerContainer> map = this.listenerContainers;
        synchronized (map) {
            Assert.state((!this.listenerContainers.containsKey(id) ? 1 : 0) != 0, (String)("Another endpoint is already registered with id '" + id + "'"));
            MessageListenerContainer container = this.createListenerContainer(endpoint, factory);
            this.listenerContainers.put(id, container);
            if (StringUtils.hasText((String)endpoint.getGroup()) && this.applicationContext != null) {
                List<MessageListenerContainer> containerGroup;
                if (this.applicationContext.containsBean(endpoint.getGroup())) {
                    containerGroup = (List)this.applicationContext.getBean(endpoint.getGroup(), List.class);
                } else {
                    containerGroup = new ArrayList();
                    this.applicationContext.getBeanFactory().registerSingleton(endpoint.getGroup(), containerGroup);
                }
                containerGroup.add(container);
            }
            if (this.contextRefreshed) {
                container.lazyLoad();
            }
            if (startImmediately) {
                this.startIfNecessary(container);
            }
        }
    }

    protected MessageListenerContainer createListenerContainer(RabbitListenerEndpoint endpoint, RabbitListenerContainerFactory<?> factory) {
        int containerPhase;
        Object listenerContainer = factory.createListenerContainer(endpoint);
        if (listenerContainer instanceof InitializingBean) {
            try {
                ((InitializingBean)listenerContainer).afterPropertiesSet();
            }
            catch (Exception ex) {
                throw new BeanInitializationException("Failed to initialize message listener container", (Throwable)ex);
            }
        }
        if ((containerPhase = listenerContainer.getPhase()) < Integer.MAX_VALUE) {
            if (this.phase < Integer.MAX_VALUE && this.phase != containerPhase) {
                throw new IllegalStateException("Encountered phase mismatch between container factory definitions: " + this.phase + " vs " + containerPhase);
            }
            this.phase = listenerContainer.getPhase();
        }
        return listenerContainer;
    }

    @Nullable
    public MessageListenerContainer unregisterListenerContainer(String id) {
        return this.listenerContainers.remove(id);
    }

    public void destroy() {
        for (MessageListenerContainer listenerContainer : this.getListenerContainers()) {
            if (!(listenerContainer instanceof DisposableBean)) continue;
            try {
                ((DisposableBean)listenerContainer).destroy();
            }
            catch (Exception ex) {
                this.logger.warn((Object)("Failed to destroy listener container [" + listenerContainer + "]"), (Throwable)ex);
            }
        }
    }

    public int getPhase() {
        return this.phase;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void start() {
        for (MessageListenerContainer listenerContainer : this.getListenerContainers()) {
            this.startIfNecessary(listenerContainer);
        }
    }

    public void stop() {
        for (MessageListenerContainer listenerContainer : this.getListenerContainers()) {
            listenerContainer.stop();
        }
    }

    public void stop(Runnable callback) {
        Collection<MessageListenerContainer> containers = this.getListenerContainers();
        AggregatingCallback aggregatingCallback = new AggregatingCallback(containers.size(), callback);
        for (MessageListenerContainer listenerContainer : containers) {
            try {
                listenerContainer.stop(aggregatingCallback);
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)("Failed to stop listener container [" + listenerContainer + "]"), (Throwable)e);
            }
        }
    }

    public boolean isRunning() {
        for (MessageListenerContainer listenerContainer : this.getListenerContainers()) {
            if (!listenerContainer.isRunning()) continue;
            return true;
        }
        return false;
    }

    private void startIfNecessary(MessageListenerContainer listenerContainer) {
        if (this.contextRefreshed || listenerContainer.isAutoStartup()) {
            listenerContainer.start();
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().equals(this.applicationContext)) {
            this.contextRefreshed = true;
        }
    }

    private static final class AggregatingCallback
    implements Runnable {
        private final AtomicInteger count;
        private final Runnable finishCallback;

        AggregatingCallback(int count, Runnable finishCallback) {
            this.count = new AtomicInteger(count);
            this.finishCallback = finishCallback;
        }

        @Override
        public void run() {
            if (this.count.decrementAndGet() == 0) {
                this.finishCallback.run();
            }
        }
    }
}

