/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.crypto.encrypt;

import org.springframework.security.crypto.encrypt.AndroidAesBytesEncryptor;
import org.springframework.security.crypto.encrypt.BytesEncryptor;
import org.springframework.security.crypto.encrypt.HexEncodingTextEncryptor;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.crypto.keygen.AndroidKeyGenerators;

public class AndroidEncryptors {
    private static final TextEncryptor NO_OP_TEXT_INSTANCE = new NoOpTextEncryptor();

    public static BytesEncryptor standard(CharSequence password, CharSequence salt) {
        return new AndroidAesBytesEncryptor(((Object)password).toString(), salt, AndroidKeyGenerators.secureRandom(16));
    }

    public static TextEncryptor text(CharSequence password, CharSequence salt) {
        return new HexEncodingTextEncryptor(AndroidEncryptors.standard(password, salt));
    }

    public static TextEncryptor queryableText(CharSequence password, CharSequence salt) {
        return new HexEncodingTextEncryptor((BytesEncryptor)new AndroidAesBytesEncryptor(((Object)password).toString(), salt, AndroidKeyGenerators.shared(16)));
    }

    public static TextEncryptor noOpText() {
        return NO_OP_TEXT_INSTANCE;
    }

    private AndroidEncryptors() {
    }

    private static final class NoOpTextEncryptor
    implements TextEncryptor {
        private NoOpTextEncryptor() {
        }

        public String encrypt(String text) {
            return text;
        }

        public String decrypt(String encryptedText) {
            return encryptedText;
        }
    }
}

