/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.crypto.keygen;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import org.springframework.security.crypto.keygen.BytesKeyGenerator;

final class AndroidSecureRandomBytesKeyGenerator
implements BytesKeyGenerator {
    private final SecureRandom random;
    private final int keyLength;
    private static final String DEFAULT_ALGORITHM = "SHA1PRNG";
    private static final String DEFAULT_PROVIDER = "Crypto";
    private static final int DEFAULT_KEY_LENGTH = 8;

    public AndroidSecureRandomBytesKeyGenerator() {
        this(DEFAULT_ALGORITHM, DEFAULT_PROVIDER, 8);
    }

    public AndroidSecureRandomBytesKeyGenerator(int keyLength) {
        this(DEFAULT_ALGORITHM, DEFAULT_PROVIDER, keyLength);
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public byte[] generateKey() {
        byte[] bytes = new byte[this.keyLength];
        this.random.nextBytes(bytes);
        return bytes;
    }

    private AndroidSecureRandomBytesKeyGenerator(String algorithm, String provider, int keyLength) {
        this.random = this.createSecureRandom(algorithm, provider, keyLength);
        this.keyLength = keyLength;
    }

    private SecureRandom createSecureRandom(String algorithm, String provider, int keyLength) {
        try {
            SecureRandom random = SecureRandom.getInstance(algorithm, provider);
            random.setSeed(random.generateSeed(keyLength));
            return random;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Not a supported SecureRandom key generation algorithm", e);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalArgumentException("Not a supported SecureRandom key provider", e);
        }
    }
}

