/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import android.os.Build;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AbstractClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpResponse;

final class SimpleStreamingClientHttpRequest
extends AbstractClientHttpRequest {
    private static final Boolean olderThanFroyo = Build.VERSION.SDK_INT < 8;
    private final HttpURLConnection connection;
    private final int chunkSize;
    private OutputStream body;

    SimpleStreamingClientHttpRequest(HttpURLConnection connection, int chunkSize) {
        this.connection = connection;
        this.chunkSize = chunkSize;
        if (olderThanFroyo.booleanValue()) {
            System.setProperty("http.keepAlive", "false");
        }
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.connection.getRequestMethod());
    }

    @Override
    public URI getURI() {
        try {
            return this.connection.getURL().toURI();
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Could not get HttpURLConnection URI: " + ex.getMessage(), ex);
        }
    }

    @Override
    protected OutputStream getBodyInternal(HttpHeaders headers) throws IOException {
        if (this.body == null) {
            int contentLength = (int)headers.getContentLength();
            if (contentLength >= 0 && !olderThanFroyo.booleanValue()) {
                this.connection.setFixedLengthStreamingMode(contentLength);
            } else {
                this.connection.setChunkedStreamingMode(this.chunkSize);
            }
            this.writeHeaders(headers);
            this.connection.connect();
            this.body = this.connection.getOutputStream();
        }
        return new NonClosingOutputStream(this.body);
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
        try {
            if (this.body != null) {
                this.body.close();
            } else {
                this.writeHeaders(headers);
                this.connection.connect();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new SimpleClientHttpResponse(this.connection);
    }

    private void writeHeaders(HttpHeaders headers) {
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String headerName = entry.getKey();
            for (String headerValue : entry.getValue()) {
                if (!this.shouldAllowConnectionReuse(headerName, headerValue)) continue;
                this.connection.addRequestProperty(headerName, headerValue);
            }
        }
    }

    private boolean shouldAllowConnectionReuse(String headerName, String headerValue) {
        return olderThanFroyo == false || !headerName.equals("Connection") || !headerValue.equals("Keep-Alive");
    }

    private static class NonClosingOutputStream
    extends FilterOutputStream {
        private NonClosingOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

