/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.springframework.http.ContentCodingType;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;

public abstract class AbstractClientHttpRequest
implements ClientHttpRequest {
    private final HttpHeaders headers = new HttpHeaders();
    private boolean executed = false;
    private OutputStream compressedBody;

    @Override
    public final HttpHeaders getHeaders() {
        return this.executed ? HttpHeaders.readOnlyHttpHeaders(this.headers) : this.headers;
    }

    @Override
    public final OutputStream getBody() throws IOException {
        this.checkExecuted();
        OutputStream body = this.getBodyInternal(this.headers);
        if (this.shouldCompress()) {
            return this.getCompressedBody(body);
        }
        return body;
    }

    @Override
    public final ClientHttpResponse execute() throws IOException {
        this.checkExecuted();
        if (this.compressedBody != null) {
            this.compressedBody.close();
        }
        ClientHttpResponse result = this.executeInternal(this.headers);
        this.executed = true;
        return result;
    }

    protected abstract OutputStream getBodyInternal(HttpHeaders var1) throws IOException;

    protected abstract ClientHttpResponse executeInternal(HttpHeaders var1) throws IOException;

    private void checkExecuted() {
        Assert.state((!this.executed ? 1 : 0) != 0, (String)"ClientHttpRequest already executed");
    }

    private boolean shouldCompress() {
        List<ContentCodingType> contentCodingTypes = this.headers.getContentEncoding();
        for (ContentCodingType contentCodingType : contentCodingTypes) {
            if (!contentCodingType.equals(ContentCodingType.GZIP)) continue;
            return true;
        }
        return false;
    }

    private OutputStream getCompressedBody(OutputStream body) throws IOException {
        if (this.compressedBody == null) {
            this.compressedBody = new GZIPOutputStream(body);
        }
        return this.compressedBody;
    }
}

