/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.service;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.batch.admin.service.SearchableStepExecutionDao;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.dao.JdbcStepExecutionDao;
import org.springframework.batch.item.database.PagingQueryProvider;
import org.springframework.batch.item.database.support.SqlPagingQueryProviderFactoryBean;
import org.springframework.batch.support.PatternMatcher;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcOperations;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.support.incrementer.AbstractDataFieldMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcSearchableStepExecutionDao
extends JdbcStepExecutionDao
implements SearchableStepExecutionDao {
    private static final String STEP_EXECUTIONS_FOR_JOB = "SELECT distinct STEP_NAME from %PREFIX%STEP_EXECUTION S, %PREFIX%JOB_EXECUTION E, %PREFIX%JOB_INSTANCE I where S.JOB_EXECUTION_ID = E.JOB_EXECUTION_ID AND E.JOB_INSTANCE_ID = E.JOB_INSTANCE_ID AND I.JOB_NAME = ?";
    private static final String COUNT_STEP_EXECUTIONS_FOR_STEP = "SELECT COUNT(STEP_EXECUTION_ID) from %PREFIX%STEP_EXECUTION where STEP_NAME = ?";
    private static final String COUNT_STEP_EXECUTIONS_FOR_STEP_PATTERN = "SELECT COUNT(STEP_EXECUTION_ID) from %PREFIX%STEP_EXECUTION where STEP_NAME like ?";
    private static final String FIELDS = "STEP_EXECUTION_ID, STEP_NAME, START_TIME, END_TIME, STATUS, COMMIT_COUNT, READ_COUNT, FILTER_COUNT, WRITE_COUNT, EXIT_CODE, EXIT_MESSAGE, READ_SKIP_COUNT, WRITE_SKIP_COUNT, PROCESS_SKIP_COUNT, ROLLBACK_COUNT, LAST_UPDATED, VERSION";
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void afterPropertiesSet() throws Exception {
        this.setJdbcTemplate((SimpleJdbcOperations)new SimpleJdbcTemplate(this.dataSource));
        this.setStepExecutionIncrementer((DataFieldMaxValueIncrementer)new AbstractDataFieldMaxValueIncrementer(){

            protected long getNextKey() {
                return 0L;
            }
        });
        super.afterPropertiesSet();
    }

    @Override
    public Collection<String> findStepNamesForJobExecution(String jobName, String excludesPattern) {
        List list = this.getJdbcTemplate().query(this.getQuery(STEP_EXECUTIONS_FOR_JOB), (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString(1);
            }
        }, new Object[]{jobName});
        LinkedHashSet<String> stepNames = new LinkedHashSet<String>(list);
        Iterator iterator = stepNames.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (!PatternMatcher.match((String)excludesPattern, (String)name)) continue;
            iterator.remove();
        }
        return stepNames;
    }

    @Override
    public Collection<StepExecution> findStepExecutions(String stepName, int start, int count) {
        String whereClause = "STEP_NAME = ?";
        if (stepName.contains("*")) {
            whereClause = "STEP_NAME like ?";
            stepName = stepName.replace("*", "%");
        }
        PagingQueryProvider queryProvider = this.getPagingQueryProvider(whereClause);
        if (start <= 0) {
            return this.getJdbcTemplate().query(queryProvider.generateFirstPageQuery(count), (RowMapper)new StepExecutionRowMapper(), new Object[]{stepName});
        }
        Long startAfterValue = this.getJdbcTemplate().queryForLong(queryProvider.generateJumpToItemQuery(start, count), new Object[]{stepName});
        return this.getJdbcTemplate().query(queryProvider.generateRemainingPagesQuery(count), (RowMapper)new StepExecutionRowMapper(), new Object[]{stepName, startAfterValue});
    }

    @Override
    public int countStepExecutions(String stepName) {
        if (stepName.contains("*")) {
            return this.getJdbcTemplate().queryForInt(this.getQuery(COUNT_STEP_EXECUTIONS_FOR_STEP_PATTERN), new Object[]{stepName.replace("*", "%")});
        }
        return this.getJdbcTemplate().queryForInt(this.getQuery(COUNT_STEP_EXECUTIONS_FOR_STEP), new Object[]{stepName});
    }

    private PagingQueryProvider getPagingQueryProvider(String whereClause) {
        SqlPagingQueryProviderFactoryBean factory = new SqlPagingQueryProviderFactoryBean();
        factory.setDataSource(this.dataSource);
        factory.setFromClause(this.getQuery("%PREFIX%STEP_EXECUTION"));
        factory.setSelectClause(FIELDS);
        factory.setSortKey("STEP_EXECUTION_ID");
        factory.setAscending(false);
        if (whereClause != null) {
            factory.setWhereClause(whereClause);
        }
        try {
            return (PagingQueryProvider)factory.getObject();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected exception creating paging query provide", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StepExecutionRowMapper
    implements RowMapper<StepExecution> {
        private StepExecutionRowMapper() {
        }

        public StepExecution mapRow(ResultSet rs, int rowNum) throws SQLException {
            StepExecution stepExecution = new StepExecution(rs.getString(2), null);
            stepExecution.setId(Long.valueOf(rs.getLong(1)));
            stepExecution.setStartTime((Date)rs.getTimestamp(3));
            stepExecution.setEndTime((Date)rs.getTimestamp(4));
            stepExecution.setStatus(BatchStatus.valueOf((String)rs.getString(5)));
            stepExecution.setCommitCount(rs.getInt(6));
            stepExecution.setReadCount(rs.getInt(7));
            stepExecution.setFilterCount(rs.getInt(8));
            stepExecution.setWriteCount(rs.getInt(9));
            stepExecution.setExitStatus(new ExitStatus(rs.getString(10), rs.getString(11)));
            stepExecution.setReadSkipCount(rs.getInt(12));
            stepExecution.setWriteSkipCount(rs.getInt(13));
            stepExecution.setProcessSkipCount(rs.getInt(14));
            stepExecution.setRollbackCount(rs.getInt(15));
            stepExecution.setLastUpdated((Date)rs.getTimestamp(16));
            stepExecution.setVersion(Integer.valueOf(rs.getInt(17)));
            return stepExecution;
        }
    }
}

