/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.test.datasource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceInitializer
implements InitializingBean {
    private Resource[] initScripts;
    private Resource destroyScript;
    private DataSource dataSource;
    private boolean initialize = false;
    private Log logger = LogFactory.getLog(this.getClass());
    private static boolean initialized = false;

    public void setInitialize(boolean initialize) {
        this.initialize = initialize;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.dataSource);
        this.logger.info((Object)("Initializing with scripts: " + Arrays.asList(this.initScripts)));
        if (!initialized && this.initialize) {
            try {
                this.doExecuteScript(this.destroyScript);
            }
            catch (Exception e) {
                this.logger.debug((Object)("Could not execute destroy script [" + this.destroyScript + "]"), (Throwable)e);
            }
            if (this.initScripts != null) {
                for (int i = 0; i < this.initScripts.length; ++i) {
                    Resource initScript = this.initScripts[i];
                    this.logger.info((Object)("Executing init script: " + initScript));
                    this.doExecuteScript(initScript);
                }
            }
            initialized = true;
        }
    }

    private void doExecuteScript(final Resource scriptResource) {
        if (scriptResource == null || !scriptResource.exists()) {
            return;
        }
        TransactionTemplate transactionTemplate = new TransactionTemplate((PlatformTransactionManager)new DataSourceTransactionManager(this.dataSource));
        transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus status) {
                String[] scripts;
                JdbcTemplate jdbcTemplate = new JdbcTemplate(DataSourceInitializer.this.dataSource);
                try {
                    scripts = StringUtils.delimitedListToStringArray((String)DataSourceInitializer.this.stripComments(IOUtils.readLines((InputStream)scriptResource.getInputStream())), (String)";");
                }
                catch (IOException e) {
                    throw new BeanInitializationException("Cannot load script from [" + scriptResource + "]", (Throwable)e);
                }
                for (int i = 0; i < scripts.length; ++i) {
                    String script = scripts[i].trim();
                    if (!StringUtils.hasText((String)script)) continue;
                    jdbcTemplate.execute(scripts[i]);
                }
                return null;
            }
        });
    }

    private String stripComments(List<String> list) {
        StringBuffer buffer = new StringBuffer();
        for (String line : list) {
            if (line.startsWith("//") || line.startsWith("--")) continue;
            buffer.append(line + "\n");
        }
        return buffer.toString();
    }

    public Class<DataSource> getObjectType() {
        return DataSource.class;
    }

    public void setInitScripts(Resource[] initScripts) {
        this.initScripts = initScripts;
    }

    public void setDestroyScript(Resource destroyScript) {
        this.destroyScript = destroyScript;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

