/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.TimeZone;
import org.springframework.batch.admin.service.JobService;
import org.springframework.batch.admin.web.JobExecutionInfo;
import org.springframework.batch.admin.web.JobInfo;
import org.springframework.batch.admin.web.JobInstanceInfo;
import org.springframework.batch.admin.web.LaunchRequest;
import org.springframework.batch.admin.web.TableUtils;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.support.PropertiesConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class JobController {
    private final JobService jobService;

    @Autowired
    public JobController(JobService jobService) {
        this.jobService = jobService;
    }

    @RequestMapping(value={"/jobs/{jobName}"}, method={RequestMethod.POST})
    public String launch(Model model, @PathVariable String jobName, @ModelAttribute(value="launchRequest") LaunchRequest launchRequest, Errors errors, @RequestParam(defaultValue="job") String origin) {
        launchRequest.setJobName(jobName);
        String params = launchRequest.jobParameters;
        DefaultJobParametersConverter converter = new DefaultJobParametersConverter();
        Properties properties = PropertiesConverter.stringToProperties((String)params);
        JobParameters jobParameters = converter.getJobParameters(properties);
        try {
            JobExecution jobExecution = this.jobService.launch(jobName, jobParameters);
            model.addAttribute((Object)new JobExecutionInfo(jobExecution, TimeZone.getTimeZone("GMT")));
        }
        catch (NoSuchJobException e) {
            errors.reject("no.such.job", new Object[]{jobName}, "No such job: " + jobName);
        }
        catch (JobExecutionAlreadyRunningException e) {
            errors.reject("job.already.running", "A job with this name and parameters is already running.");
        }
        catch (JobRestartException e) {
            errors.reject("job.could.not.restart", "The job was not able to restart.");
        }
        catch (JobInstanceAlreadyCompleteException e) {
            errors.reject("job.already.complete", "A job with this name and parameters already completed successfully.");
        }
        catch (JobParametersInvalidException e) {
            errors.reject("job.parameters.invalid", "The job parameters are invalid according to the configuration.");
        }
        if ("execution".equals(origin)) {
            return "jobs/execution";
        }
        return this.details(model, jobName, 0, 20);
    }

    @RequestMapping(value={"/jobs/{jobName}"}, method={RequestMethod.GET})
    public String details(Model model, @PathVariable String jobName, @RequestParam(defaultValue="0") int startJobInstance, @RequestParam(defaultValue="20") int pageSize) {
        model.addAttribute("launchable", (Object)this.jobService.isLaunchable(jobName));
        try {
            Collection<JobInstance> result = this.jobService.listJobInstances(jobName, startJobInstance, pageSize);
            ArrayList<JobInstanceInfo> jobInstances = new ArrayList<JobInstanceInfo>();
            for (JobInstance jobInstance : result) {
                jobInstances.add(new JobInstanceInfo(jobInstance, this.jobService.getJobExecutionsForJobInstance(jobName, jobInstance.getId())));
            }
            model.addAttribute("jobInstances", jobInstances);
            int total = this.jobService.countJobInstances(jobName);
            TableUtils.addPagination(model, total, startJobInstance, pageSize, "JobInstance");
            int count = this.jobService.countJobExecutionsForJob(jobName);
            model.addAttribute("job", (Object)new JobInfo(jobName, count));
        }
        catch (NoSuchJobException e) {
            // empty catch block
        }
        return "jobs/job";
    }

    @RequestMapping(value={"/jobs"}, method={RequestMethod.GET})
    public void jobs(Model model, @RequestParam(defaultValue="0") int startJob, @RequestParam(defaultValue="20") int pageSize) {
        int total = this.jobService.countJobs();
        TableUtils.addPagination(model, total, startJob, pageSize, "Job");
        Collection<String> names = this.jobService.listJobs(startJob, pageSize);
        ArrayList<JobInfo> jobs = new ArrayList<JobInfo>();
        for (String name : names) {
            int count = 0;
            try {
                count = this.jobService.countJobExecutionsForJob(name);
            }
            catch (NoSuchJobException e) {
                // empty catch block
            }
            boolean launchable = this.jobService.isLaunchable(name);
            jobs.add(new JobInfo(name, count, launchable));
        }
        model.addAttribute("jobs", jobs);
    }
}

