/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.springframework.integration.core.Message;
import org.springframework.integration.http.InboundRequestMapper;
import org.springframework.integration.message.MessageBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BodyInboundRequestMapper
implements InboundRequestMapper {
    public Message<?> toMessage(HttpServletRequest request) throws Exception {
        MessageBuilder builder = MessageBuilder.withPayload((Object)this.createPayloadFromTextContent(request));
        this.populateHeaders(request, builder);
        return builder.build();
    }

    private Object createPayloadFromTextContent(HttpServletRequest request) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = request.getReader();
        String line = reader.readLine();
        while (line != null) {
            sb.append(line + "\n");
            line = reader.readLine();
        }
        return sb.toString();
    }

    private void populateHeaders(HttpServletRequest request, MessageBuilder<?> builder) {
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                Enumeration headerEnum = request.getHeaders(headerName);
                if (headerEnum == null) continue;
                ArrayList headers = new ArrayList();
                while (headerEnum.hasMoreElements()) {
                    headers.add(headerEnum.nextElement());
                }
                if (headers.size() == 1) {
                    builder.setHeader(headerName, headers.get(0));
                    continue;
                }
                if (headers.size() <= 1) continue;
                builder.setHeader(headerName, headers);
            }
        }
        builder.setHeader("springintegration_http_requestUrl", (Object)request.getRequestURL().toString());
        builder.setHeader("springintegration_http_requestMethod", (Object)request.getMethod());
        builder.setHeader("springintegration_http_userPrincipal", (Object)request.getUserPrincipal());
    }
}

