/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.springframework.batch.admin.service.JobService;
import org.springframework.batch.admin.web.JobExecutionInfo;
import org.springframework.batch.admin.web.JobInfo;
import org.springframework.batch.admin.web.JobInstanceInfo;
import org.springframework.batch.admin.web.LaunchRequest;
import org.springframework.batch.admin.web.TableUtils;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.support.PropertiesConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
public class JobController {
    private final JobService jobService;
    private JobParametersConverter converter = new DefaultJobParametersConverter();
    private TimeZone timeZone = TimeZone.getDefault();

    @Autowired(required=false)
    @Qualifier(value="userTimeZone")
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Autowired
    public JobController(JobService jobService) {
        this.jobService = jobService;
    }

    @RequestMapping(value={"/jobs/{jobName}"}, method={RequestMethod.POST})
    public String launch(ModelMap model, @PathVariable String jobName, @ModelAttribute(value="launchRequest") LaunchRequest launchRequest, Errors errors, @RequestParam(defaultValue="job") String origin) {
        launchRequest.setJobName(jobName);
        String params = launchRequest.jobParameters;
        Properties properties = PropertiesConverter.stringToProperties((String)params);
        JobParameters jobParameters = this.converter.getJobParameters(properties);
        try {
            JobExecution jobExecution = this.jobService.launch(jobName, jobParameters);
            model.addAttribute((Object)new JobExecutionInfo(jobExecution, this.timeZone));
        }
        catch (NoSuchJobException e) {
            errors.reject("no.such.job", new Object[]{jobName}, "No such job: " + jobName);
        }
        catch (JobExecutionAlreadyRunningException e) {
            errors.reject("job.already.running", "A job with this name and parameters is already running.");
        }
        catch (JobRestartException e) {
            errors.reject("job.could.not.restart", "The job was not able to restart.");
        }
        catch (JobInstanceAlreadyCompleteException e) {
            errors.reject("job.already.complete", "A job with this name and parameters already completed successfully.");
        }
        catch (JobParametersInvalidException e) {
            errors.reject("job.parameters.invalid", "The job parameters are invalid according to the configuration.");
        }
        if ("execution".equals(origin)) {
            return "jobs/execution";
        }
        return this.details(model, jobName, new Date(), errors, 0, 20);
    }

    @RequestMapping(value={"/jobs/{jobName}"}, method={RequestMethod.GET})
    public String details(ModelMap model, @PathVariable String jobName, @ModelAttribute(value="date") Date date, Errors errors, @RequestParam(defaultValue="0") int startJobInstance, @RequestParam(defaultValue="20") int pageSize) {
        model.addAttribute("launchable", (Object)this.jobService.isLaunchable(jobName));
        try {
            Collection<JobInstance> result = this.jobService.listJobInstances(jobName, startJobInstance, pageSize);
            ArrayList<JobInstanceInfo> jobInstances = new ArrayList<JobInstanceInfo>();
            for (JobInstance jobInstance : result) {
                jobInstances.add(new JobInstanceInfo(jobInstance, this.jobService.getJobExecutionsForJobInstance(jobName, jobInstance.getId())));
            }
            model.addAttribute("jobInstances", jobInstances);
            model.addAttribute("jobParameters", (Object)this.getLastJobParameters(jobInstances));
            int total = this.jobService.countJobInstances(jobName);
            TableUtils.addPagination((Map<String, Object>)model, total, startJobInstance, pageSize, "JobInstance");
            int count = this.jobService.countJobExecutionsForJob(jobName);
            model.addAttribute("job", (Object)new JobInfo(jobName, count));
        }
        catch (NoSuchJobException e) {
            errors.reject("no.such.job", new Object[]{jobName}, "There is no such job (" + jobName + ")");
        }
        return "jobs/job";
    }

    private String getLastJobParameters(Collection<JobInstanceInfo> lastInstances) {
        JobInstance lastInstance = null;
        if (!lastInstances.isEmpty()) {
            lastInstance = lastInstances.iterator().next().getJobInstance();
        }
        JobParameters oldParameters = new JobParameters();
        if (lastInstance != null) {
            oldParameters = lastInstance.getJobParameters();
        }
        return PropertiesConverter.propertiesToString((Properties)this.converter.getProperties(oldParameters));
    }

    @RequestMapping(value={"/jobs"}, method={RequestMethod.GET})
    public void jobs(ModelMap model, @RequestParam(defaultValue="0") int startJob, @RequestParam(defaultValue="20") int pageSize) {
        int total = this.jobService.countJobs();
        TableUtils.addPagination((Map<String, Object>)model, total, startJob, pageSize, "Job");
        Collection<String> names = this.jobService.listJobs(startJob, pageSize);
        ArrayList<JobInfo> jobs = new ArrayList<JobInfo>();
        for (String name : names) {
            int count = 0;
            try {
                count = this.jobService.countJobExecutionsForJob(name);
            }
            catch (NoSuchJobException e) {
                // empty catch block
            }
            boolean launchable = this.jobService.isLaunchable(name);
            boolean incrementable = this.jobService.isIncrementable(name);
            jobs.add(new JobInfo(name, count, null, launchable, incrementable));
        }
        model.addAttribute("jobs", jobs);
    }
}

