/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.jmx;

import java.util.Date;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.support.MetricType;

public interface JobExecutionMetrics {
    @ManagedMetric(metricType=MetricType.COUNTER, description="Job Execution Count")
    public int getExecutionCount();

    @ManagedMetric(metricType=MetricType.COUNTER, description="Job Execution Failure Count")
    public int getFailureCount();

    @ManagedMetric(metricType=MetricType.GAUGE, description="Latest Duration Milliseconds")
    public double getLatestDuration();

    @ManagedMetric(metricType=MetricType.GAUGE, description="Mean Duration Milliseconds")
    public double getMeanDuration();

    @ManagedMetric(metricType=MetricType.GAUGE, description="Max Duration Milliseconds")
    public double getMaxDuration();

    @ManagedAttribute(description="Latest Job Execution ID")
    public long getLatestExecutionId();

    @ManagedAttribute(description="Latest Start Time")
    public Date getLatestStartTime();

    @ManagedAttribute(description="Latest End Time")
    public Date getLatestEndTime();

    @ManagedAttribute(description="Latest Exit Code")
    public String getLatestExitCode();

    @ManagedAttribute(description="Latest Status")
    public String getLatestStatus();

    @ManagedAttribute(description="Latest Step Execution Exit Description")
    public String getLatestStepExitDescription();

    @ManagedAttribute(description="Check if there is a Running Job Execution")
    public boolean isJobRunning();
}

